/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    CThread cthread;

    public StackFrame(CThread thread, MIFrame f) {
        super(thread.getCTarget());
        this.cthread = thread;
        this.frame = f;
    }

    MIFrame getMIFrame() {
        return this.frame;
    }

    CThread getCThread() {
        return this.cthread;
    }

    public ICDIArgument[] getArguments() throws CDIException {
        ArrayList<ICDIArgument> cdiList;
        block9: {
            cdiList = new ArrayList<ICDIArgument>();
            if (this.frame != null) {
                CSession session = this.getCTarget().getCSession();
                VariableManager mgr = session.getVariableManager();
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                int level = this.frame.getLevel();
                MIStackListArguments listArgs = factory.createMIStackListArguments(false, level, level);
                try {
                    this.cthread.setCurrentStackFrame(this);
                    MIArg[] args = null;
                    mi.postCommand(listArgs);
                    MIStackListArgumentsInfo info = listArgs.getMIStackListArgumentsInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    if (miFrames != null && miFrames.length == 1) {
                        args = miFrames[0].getArgs();
                    }
                    if (args == null) break block9;
                    int i = 0;
                    while (i < args.length) {
                        try {
                            cdiList.add(mgr.createArgument(this, args[i].getName()));
                        }
                        catch (CDIException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (MIException e) {
                }
                catch (CDIException e) {
                    // empty catch block
                }
            }
        }
        return cdiList.toArray(new ICDIArgument[0]);
    }

    public ICDIVariable[] getLocalVariables() throws CDIException {
        ArrayList<ICDIVariable> cdiList;
        block7: {
            cdiList = new ArrayList<ICDIVariable>();
            CSession session = this.getCTarget().getCSession();
            VariableManager mgr = session.getVariableManager();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIStackListLocals locals = factory.createMIStackListLocals(false);
            try {
                this.cthread.setCurrentStackFrame(this);
                MIArg[] args = null;
                mi.postCommand(locals);
                MIStackListLocalsInfo info = locals.getMIStackListLocalsInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                args = info.getLocals();
                if (args == null) break block7;
                int i = 0;
                while (i < args.length) {
                    try {
                        cdiList.add(mgr.createVariable(this, args[i].getName()));
                    }
                    catch (CDIException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (MIException e) {
            }
            catch (CDIException e) {
                // empty catch block
            }
        }
        return cdiList.toArray(new ICDIVariable[0]);
    }

    public ICDILocation getLocation() {
        if (this.frame != null) {
            return new Location(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), this.frame.getAddress());
        }
        return new Location("", "", 0, 0L);
    }

    public int getLevel() {
        if (this.frame != null) {
            return this.frame.getLevel();
        }
        return 0;
    }

    public boolean equals(ICDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            StackFrame stack = (StackFrame)stackframe;
            return this.cthread != null && this.cthread.equals(stack.getCThread()) && this.frame != null && this.frame.getLevel() == stack.getMIFrame().getLevel() && this.frame.getFile().equals(stack.getMIFrame().getFile()) && this.frame.getFunction().equals(stack.getMIFrame().getFunction());
        }
        return super.equals(stackframe);
    }
}

