/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public abstract class Command {
    private static int globalCounter;
    int token = 0;
    MIOutput output;

    private static synchronized int getUniqToken() {
        int count;
        if ((count = ++globalCounter) <= 0) {
            globalCounter = 1;
            count = 1;
        }
        return count;
    }

    public int getToken() {
        if (this.token == 0) {
            this.token = Command.getUniqToken();
        }
        return this.token;
    }

    public MIOutput getMIOutput() {
        return this.output;
    }

    public void setMIOutput(MIOutput mi) {
        this.output = mi;
    }

    public MIInfo getMIInfo() throws MIException {
        MIInfo info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MIInfo(out)).isError()) {
            String mesg = info.getErrorMsg();
            StringBuffer sb = new StringBuffer();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MILogStreamOutput) {
                    MIStreamRecord o = (MIStreamRecord)oobs[i];
                    sb.append(o.getString());
                }
                ++i;
            }
            throw new MIException(mesg, sb.toString());
        }
        return info;
    }
}

