/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIBreakPoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakInsertInfo
extends MIInfo {
    MIBreakPoint[] breakpoints;

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIBreakPoint> aList = new ArrayList<MIBreakPoint>(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue val = results[i].getMIValue();
                MIBreakPoint bpt = null;
                if (var.equals("wpt")) {
                    if (val instanceof MITuple) {
                        bpt = new MIBreakPoint((MITuple)val);
                        bpt.setEnabled(true);
                        bpt.setWriteWatchpoint(true);
                    }
                } else if (var.equals("bkpt")) {
                    if (val instanceof MITuple) {
                        bpt = new MIBreakPoint((MITuple)val);
                        bpt.setEnabled(true);
                    }
                } else if (var.equals("hw-awpt")) {
                    if (val instanceof MITuple) {
                        bpt = new MIBreakPoint((MITuple)val);
                        bpt.setAccessWatchpoint(true);
                        bpt.setEnabled(true);
                    }
                } else if (var.equals("hw-rwpt") && val instanceof MITuple) {
                    bpt = new MIBreakPoint((MITuple)val);
                    bpt.setReadWatchpoint(true);
                    bpt.setEnabled(true);
                }
                if (bpt != null) {
                    aList.add(bpt);
                }
                ++i;
            }
        }
        this.breakpoints = aList.toArray(new MIBreakPoint[aList.size()]);
    }

    public MIBreakInsertInfo(MIOutput record) {
        super(record);
    }

    public MIBreakPoint[] getBreakPoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }
}

