/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.ICFolder;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ICResource;
import org.eclipse.cdt.core.model.ICRoot;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CFile;
import org.eclipse.cdt.internal.core.model.CFolder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CRoot;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.parser.ElfParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class CModelManager
implements IResourceChangeListener {
    private Map fParsedResources = Collections.synchronizedMap(new HashMap());
    static final String BINARY_PARSER = "binaryparser";
    static QualifiedName binaryParserKey = new QualifiedName("org.eclipse.cdt.core.coremodel", "binaryparser");
    private static HashMap fParsers = new HashMap();
    private static IBinaryParser defaultBinaryParser = new ElfParser();
    protected DeltaProcessor fDeltaProcessor = new DeltaProcessor();
    private ArrayList fCModelDeltas = new ArrayList();
    protected boolean fFire = true;
    protected ArrayList fElementChangedListeners = new ArrayList();
    public static final String[] cExtensions = new String[]{"c", "cxx", "cc", "C", "cpp", "h", "hh"};
    static CModelManager factory = null;

    private CModelManager() {
    }

    public static CModelManager getDefault() {
        if (factory == null) {
            factory = new CModelManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)factory, 15);
        }
        return factory;
    }

    public ICRoot getCRoot(IWorkspaceRoot root) {
        return this.create(root);
    }

    public ICRoot getCRoot() {
        return this.create(ResourcesPlugin.getWorkspace().getRoot());
    }

    public ICResource create(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res == null) {
            IPath rootPath = root.getLocation();
            if (path.equals((Object)rootPath)) {
                return this.getCRoot(root);
            }
            res = root.getContainerForLocation(path);
            if (res == null || !res.exists()) {
                res = root.getFileForLocation(path);
            }
            if (res != null && !res.exists()) {
                res = null;
            }
        }
        return this.create(res);
    }

    public ICResource create(IResource resource) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return this.create((IProject)resource);
            }
            case 1: {
                return this.create((IFile)resource);
            }
            case 2: {
                return this.create((IFolder)resource);
            }
            case 8: {
                return this.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public ICResource create(ICElement parent, IResource resource) {
        int type = resource.getType();
        switch (type) {
            case 4: {
                return this.create(parent, (IProject)resource);
            }
            case 1: {
                return this.create(parent, (IFile)resource);
            }
            case 2: {
                return this.create(parent, (IFolder)resource);
            }
            case 8: {
                return this.create(parent, (IResource)((IWorkspaceRoot)resource));
            }
        }
        return null;
    }

    public ICFile create(IFile file) {
        IContainer parent = file.getParent();
        ICResource cparent = null;
        if (parent instanceof IFolder) {
            cparent = this.create((IFolder)parent);
        } else if (parent instanceof IProject) {
            cparent = this.create((IProject)parent);
        }
        if (cparent != null) {
            return this.create((ICElement)cparent, file);
        }
        return null;
    }

    public synchronized ICFile create(ICElement parent, IFile file) {
        ICFile cfile = (ICFile)this.fParsedResources.get(file);
        if (cfile == null && file.exists()) {
            cfile = this.isArchive(file) ? new Archive(parent, file) : (this.isBinary(file) ? new Binary(parent, file) : (this.isTranslationUnit(file) ? new TranslationUnit(parent, file) : new CFile(parent, file)));
            this.fParsedResources.put(file, cfile);
        }
        if (cfile != null) {
            IBinary bin;
            if (cfile instanceof IArchive) {
                CProject cproj = (CProject)cfile.getCProject();
                ArchiveContainer container = (ArchiveContainer)cproj.getArchiveContainer();
                container.addChild(cfile);
            } else if (cfile instanceof IBinary && ((bin = (IBinary)cfile).isExecutable() || bin.isSharedLib())) {
                CProject cproj = (CProject)cfile.getCProject();
                BinaryContainer container = (BinaryContainer)cproj.getBinaryContainer();
                container.addChild(bin);
            }
        }
        return cfile;
    }

    public ICFolder create(IFolder folder) {
        IContainer parent = folder.getParent();
        ICResource cparent = null;
        if (parent instanceof IFolder) {
            cparent = this.create((IFolder)parent);
        } else if (parent instanceof IProject) {
            cparent = this.create((IProject)parent);
        }
        if (cparent != null) {
            return this.create((ICElement)cparent, folder);
        }
        return null;
    }

    public synchronized ICFolder create(ICElement parent, IFolder folder) {
        ICFolder cfolder = (ICFolder)this.fParsedResources.get(folder);
        if (cfolder == null) {
            cfolder = new CFolder(parent, folder);
            this.fParsedResources.put(folder, cfolder);
        }
        return cfolder;
    }

    public ICProject create(IProject project) {
        IContainer parent = project.getParent();
        ICRoot celement = null;
        if (parent instanceof IWorkspaceRoot) {
            celement = this.create((IWorkspaceRoot)parent);
        }
        return this.create(celement, project);
    }

    public synchronized ICProject create(ICElement parent, IProject project) {
        ICProject cproject = (ICProject)this.fParsedResources.get(project);
        if (cproject == null && this.hasCNature(project)) {
            cproject = new CProject(parent, project);
            this.fParsedResources.put(project, cproject);
        }
        return cproject;
    }

    public ICRoot create(IWorkspaceRoot root) {
        ICRoot croot = (ICRoot)this.fParsedResources.get(root);
        if (croot == null) {
            croot = new CRoot(root);
            this.fParsedResources.put(root, croot);
        }
        return croot;
    }

    private void removeChildrenContainer(Parent container, IResource resource) {
        if (container.hasChildren()) {
            ICElement[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                try {
                    IResource r = children[i].getUnderlyingResource();
                    if (r.equals((Object)resource)) {
                        container.removeChild(children[i]);
                        break;
                    }
                }
                catch (CModelException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void releaseCElement(IResource resource) {
        ICElement celement = this.getCElement(resource);
        if (celement == null) {
            if (resource.exists()) {
                celement = this.create(resource);
            } else {
                CProject cproj = (CProject)this.create(resource.getProject());
                if (cproj != null) {
                    Parent container = (Parent)((Object)cproj.getArchiveContainer());
                    this.removeChildrenContainer(container, resource);
                    container = (Parent)((Object)cproj.getBinaryContainer());
                    this.removeChildrenContainer(container, resource);
                }
            }
        }
        this.releaseCElement(celement);
    }

    public void releaseCElement(ICElement celement) {
        block14: {
            Parent parent;
            if (celement == null) {
                return;
            }
            if (celement.getElementType() == 13) {
                Parent container;
                CProject cproj;
                CFile cfile = (CFile)celement;
                if (cfile.isArchive()) {
                    cproj = (CProject)cfile.getCProject();
                    container = (ArchiveContainer)cproj.getArchiveContainer();
                    container.removeChild(cfile);
                } else if (cfile.isBinary() && !((IBinary)celement).isObject()) {
                    cproj = (CProject)cfile.getCProject();
                    container = (BinaryContainer)cproj.getBinaryContainer();
                    container.removeChild(cfile);
                }
            }
            if ((parent = (Parent)celement.getParent()) != null) {
                parent.removeChild(celement);
            }
            try {
                IResource res = celement.getUnderlyingResource();
                if (res == null) break block14;
                IPath resPath = res.getFullPath();
                if (resPath != null) {
                    Set s;
                    ArrayList<IResource> list = new ArrayList<IResource>();
                    Set set = s = this.fParsedResources.keySet();
                    synchronized (set) {
                        Iterator keys = s.iterator();
                        while (keys.hasNext()) {
                            IResource r = (IResource)keys.next();
                            IPath p = r.getFullPath();
                            if (p == null || !resPath.isPrefixOf(p)) continue;
                            list.add(r);
                        }
                    }
                    int i = 0;
                    while (i < list.size()) {
                        this.fParsedResources.remove((IResource)list.get(i));
                        ++i;
                    }
                }
                this.fParsedResources.remove(res);
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
    }

    public ICElement getCElement(IResource res) {
        return (ICElement)this.fParsedResources.get(res);
    }

    public ICElement getCElement(IPath path) {
        Iterator iterator = this.fParsedResources.keySet().iterator();
        while (iterator.hasNext()) {
            IResource res = (IResource)iterator.next();
            if (!res.getFullPath().equals((Object)path)) continue;
            return (ICElement)this.fParsedResources.get(res);
        }
        return null;
    }

    public IBinaryParser getBinaryParser(IProject project) {
        IBinaryParser parser = (IBinaryParser)fParsers.get(project);
        if (parser == null) {
            String format = this.getBinaryParserFormat(project);
            if (format == null || format.length() == 0) {
                format = this.getDefaultBinaryParserFormat();
            }
            if (format != null && format.length() > 0) {
                parser = CCorePlugin.getDefault().getBinaryParser(format);
            }
            if (parser == null) {
                parser = defaultBinaryParser;
            }
            fParsers.put(project, parser);
        }
        return parser;
    }

    public String getDefaultBinaryParserFormat() {
        String format = CCorePlugin.getDefault().getPluginPreferences().getDefaultString(BINARY_PARSER);
        if (format == null || format.length() == 0) {
            return "ELF";
        }
        return format;
    }

    public String getBinaryParserFormat(IProject project) {
        String format = null;
        try {
            if (project != null) {
                format = project.getPersistentProperty(binaryParserKey);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return format;
    }

    public void setDefaultBinaryParserFormat(String format) {
        CCorePlugin.getDefault().getPluginPreferences().setDefault(BINARY_PARSER, format);
    }

    public void setBinaryParserFormat(IProject project, String format, IProgressMonitor monitor) {
        block8: {
            try {
                if (project == null) break block8;
                project.setPersistentProperty(binaryParserKey, format);
                fParsers.remove(project);
                IPath projPath = project.getFullPath();
                if (projPath != null) {
                    ICElement ce;
                    Collection c = this.fParsedResources.values();
                    ArrayList<ICElement> list = new ArrayList<ICElement>();
                    Collection collection = c;
                    synchronized (collection) {
                        Iterator values = c.iterator();
                        while (values.hasNext()) {
                            ce = (ICElement)values.next();
                            if (ce instanceof ICRoot || ce instanceof ICProject || !ce.getCProject().getProject().equals((Object)project)) continue;
                            list.add(ce);
                        }
                    }
                    int i = 0;
                    while (i < list.size()) {
                        ce = (ICElement)list.get(i);
                        this.releaseCElement(ce);
                        ++i;
                    }
                }
                CElementDelta delta = new CElementDelta(this.getCRoot());
                delta.binaryParserChanged(this.create(project));
                this.registerCModelDelta(delta);
                this.fire();
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }

    public boolean isSharedLib(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file);
            return bin.getType() == 4;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isObject(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file);
            return bin.getType() == 1;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isExecutable(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file);
            return bin.getType() == 2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isBinary(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file);
            return bin.getType() == 2 || bin.getType() == 1 || bin.getType() == 4 || bin.getType() == 16;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isArchive(IFile file) {
        try {
            IBinaryParser parser = this.getBinaryParser(file.getProject());
            IBinaryParser.IBinaryFile bin = parser.getBinary(file);
            return bin.getType() == 8;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isTranslationUnit(IFile file) {
        return this.isValidTranslationUnitName(file.getName());
    }

    public boolean isValidTranslationUnitName(String name) {
        if (name == null) {
            return false;
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String ext = name.substring(index + 1);
        int i = 0;
        while (i < cExtensions.length) {
            if (ext.equals(cExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasCNature(IProject p) {
        boolean ok = false;
        try {
            ok = p.isOpen() && p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return ok;
    }

    public boolean hasCCNature(IProject p) {
        boolean ok = false;
        try {
            ok = p.isOpen() && p.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return ok;
    }

    public synchronized void addElementChangedListener(IElementChangedListener listener) {
        if (this.fElementChangedListeners.indexOf(listener) < 0) {
            this.fElementChangedListeners.add(listener);
        }
    }

    public synchronized void removeElementChangedListener(IElementChangedListener listener) {
        int i = this.fElementChangedListeners.indexOf(listener);
        if (i != -1) {
            this.fElementChangedListeners.remove(i);
        }
    }

    public synchronized void registerCModelDelta(ICElementDelta delta) {
        this.fCModelDeltas.add(delta);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResourceDelta delta = event.getDelta();
            switch (event.getType()) {
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
                case 1: {
                    if (delta == null) break;
                    try {
                        ICElementDelta[] translatedDeltas = this.fDeltaProcessor.processResourceDelta(delta);
                        if (translatedDeltas.length > 0) {
                            int i = 0;
                            while (i < translatedDeltas.length) {
                                this.registerCModelDelta(translatedDeltas[i]);
                                ++i;
                            }
                        }
                        this.fire();
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void deleting(IResource resource) {
        this.deleting(this.getCElement(resource));
    }

    public void deleting(ICElement celement) {
        this.releaseCElement(celement);
    }

    public synchronized void fire() {
        if (this.fFire) {
            this.mergeDeltas();
            try {
                Iterator iterator = ((AbstractList)this.fCModelDeltas).iterator();
                while (iterator.hasNext()) {
                    ICElementDelta delta = (ICElementDelta)iterator.next();
                    ElementChangedEvent event = new ElementChangedEvent(delta);
                    ArrayList listeners = (ArrayList)this.fElementChangedListeners.clone();
                    int i = 0;
                    while (i < listeners.size()) {
                        IElementChangedListener listener = (IElementChangedListener)listeners.get(i);
                        listener.elementChanged(event);
                        ++i;
                    }
                }
                Object var8_7 = null;
                this.flush();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.flush();
                throw throwable;
            }
        }
    }

    protected synchronized void flush() {
        this.fCModelDeltas = new ArrayList();
    }

    private void mergeDeltas() {
        if (this.fCModelDeltas.size() <= 1) {
            return;
        }
        Iterator deltas = ((AbstractList)this.fCModelDeltas).iterator();
        ICRoot cRoot = this.getCRoot();
        CElementDelta rootDelta = new CElementDelta(cRoot);
        boolean insertedTree = false;
        while (deltas.hasNext()) {
            CElementDelta delta = (CElementDelta)deltas.next();
            ICElement element = delta.getElement();
            if (cRoot.equals(element)) {
                ICElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    CElementDelta projectDelta = (CElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            this.fCModelDeltas = new ArrayList(1);
            this.fCModelDeltas.add(rootDelta);
        } else {
            this.fCModelDeltas = new ArrayList(0);
        }
    }

    public void runOperation(CModelOperation operation, IProgressMonitor monitor) throws CModelException {
        boolean hadAwaitingDeltas = !this.fCModelDeltas.isEmpty();
        try {
            block9: {
                try {
                    if (operation.isReadOnly()) {
                        operation.run(monitor);
                        break block9;
                    }
                    this.getCRoot().getUnderlyingResource().getWorkspace().run((IWorkspaceRunnable)operation, monitor);
                }
                catch (CoreException ce) {
                    Throwable e;
                    if (ce instanceof CModelException) {
                        throw (CModelException)ce;
                    }
                    if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof CModelException) {
                        throw (CModelException)((Object)e);
                    }
                    throw new CModelException(ce);
                }
            }
            Object var7_4 = null;
            if (!hadAwaitingDeltas && !operation.hasModifiedResource()) {
                this.fire();
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!hadAwaitingDeltas && !operation.hasModifiedResource()) {
                this.fire();
            }
            throw throwable;
        }
    }
}

