/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICRoot;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class DeltaProcessor {
    protected CElementDelta fCurrentDelta;
    ICElement currentElement;
    static final ICElementDelta[] NO_DELTA = new ICElementDelta[0];
    public static boolean VERBOSE = false;
    ICElement movedFromElement = null;

    protected void contentChanged(ICElement element, IResourceDelta delta) {
        this.fCurrentDelta.changed(element, 1);
    }

    protected ICElement createElement(IResource resource) {
        if (resource == null) {
            return null;
        }
        return CModelManager.getDefault().create(resource);
    }

    protected ICElement createElement(IPath path) {
        return CModelManager.getDefault().create(path);
    }

    protected void releaseCElement(ICElement celement) {
        CModelManager.getDefault().releaseCElement(celement);
    }

    protected void releaseCElement(IResource resource) {
        CModelManager.getDefault().releaseCElement(resource);
    }

    protected ICElement getElement(IResource res) {
        return CModelManager.getDefault().getCElement(res);
    }

    protected ICElement getElement(IPath path) {
        return CModelManager.getDefault().getCElement(path);
    }

    protected void elementAdded(ICElement element, IResourceDelta delta) {
        if ((delta.getFlags() & 0x1000) != 0) {
            if (this.movedFromElement == null) {
                this.movedFromElement = this.getElement(delta.getMovedFromPath());
            }
            this.fCurrentDelta.movedTo(element, this.movedFromElement);
            this.movedFromElement = null;
        } else {
            this.fCurrentDelta.added(element);
        }
    }

    protected void elementClosed(ICElement element, IResourceDelta delta) {
        if (element.getElementType() == 11) {
            this.elementRemoved(element, delta);
        } else {
            this.fCurrentDelta.closed(element);
        }
    }

    protected void elementOpened(ICElement element, IResourceDelta delta) {
        if (element.getElementType() == 11) {
            if (this.hasCNature(delta.getResource())) {
                this.elementAdded(element, delta);
            }
        } else {
            this.fCurrentDelta.opened(element);
        }
    }

    protected void elementRemoved(ICElement element, IResourceDelta delta) {
        if ((delta.getFlags() & 0x2000) != 0) {
            IPath movedToPath = delta.getMovedToPath();
            ICElement movedToElement = this.createElement(movedToPath);
            if (movedToElement == null) {
                this.fCurrentDelta.removed(element);
            } else {
                this.movedFromElement = element;
                this.fCurrentDelta.movedFrom(element, movedToElement);
            }
        } else {
            this.fCurrentDelta.removed(element);
        }
        this.releaseCElement(element);
    }

    protected ICElementDelta[] filterRealDeltas(ICElementDelta[] deltas) {
        int length = deltas.length;
        ICElementDelta[] realDeltas = null;
        int index = 0;
        int i = 0;
        while (i < length) {
            CElementDelta delta = (CElementDelta)deltas[i];
            if (delta != null && (delta.getAffectedChildren().length > 0 || delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x400) != 0 || (delta.getFlags() & 0x200) != 0 || delta.resourceDeltasCounter > 0)) {
                if (realDeltas == null) {
                    realDeltas = new ICElementDelta[length];
                }
                realDeltas[index++] = delta;
            }
            ++i;
        }
        if (index > 0) {
            ICElementDelta[] result = new ICElementDelta[index];
            System.arraycopy(realDeltas, 0, result, 0, index);
            return result;
        }
        return NO_DELTA;
    }

    protected boolean hasCNature(IResource resource) {
        IProject project = resource.getProject();
        if (project.isOpen()) {
            return CoreModel.getDefault().hasCNature(project);
        }
        return false;
    }

    private CModelException newInvalidElementType() {
        return new CModelException(new CModelStatus(967));
    }

    public ICElementDelta[] processResourceDelta(IResourceDelta changes) {
        try {
            ICRoot root = CModelManager.getDefault().getCRoot();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            ICElementDelta[] translatedDeltas = new CElementDelta[deltas.length];
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                this.fCurrentDelta = new CElementDelta(root);
                this.traverseDelta(delta);
                translatedDeltas[i] = this.fCurrentDelta;
                ++i;
            }
            ICElementDelta[] iCElementDeltaArray = this.filterRealDeltas(translatedDeltas);
            Object var8_7 = null;
            return iCElementDeltaArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    protected void traverseDelta(IResourceDelta delta) {
        try {
            if (!this.updateCurrentDeltaAndIndex(delta)) {
                this.fCurrentDelta.addResourceDelta(delta);
            }
        }
        catch (CModelException e) {
            // empty catch block
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.traverseDelta(children[i]);
            ++i;
        }
    }

    private boolean updateCurrentDeltaAndIndex(IResourceDelta delta) throws CModelException {
        ICElement element = null;
        IResource resource = delta.getResource();
        boolean isProcess = false;
        switch (delta.getKind()) {
            case 1: {
                element = this.createElement(resource);
                if (element == null) {
                    throw this.newInvalidElementType();
                }
                this.updateIndexAddResource(element, delta);
                this.elementAdded(element, delta);
                isProcess = true;
                break;
            }
            case 2: {
                element = this.getElement(resource);
                if (element != null) {
                    this.updateIndexRemoveResource(element, delta);
                    this.elementRemoved(element, delta);
                    isProcess = true;
                    break;
                }
                this.releaseCElement(resource);
                break;
            }
            case 4: {
                element = this.createElement(resource);
                if (element == null) {
                    throw this.newInvalidElementType();
                }
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0) {
                    this.contentChanged(element, delta);
                    this.updateIndexAddResource(element, delta);
                } else if ((flags & 0x4000) != 0) {
                    IProject res = (IProject)resource;
                    if (res.isOpen()) {
                        this.elementOpened(element, delta);
                        this.updateIndexAddResource(element, delta);
                    } else {
                        this.elementClosed(element, delta);
                        this.updateIndexRemoveResource(element, delta);
                    }
                } else if ((flags & 0x80000) != 0) {
                    this.elementAdded(element, delta);
                }
                isProcess = true;
            }
        }
        return isProcess;
    }

    protected void updateIndexAddResource(ICElement element, IResourceDelta delta) {
    }

    protected void updateIndexRemoveResource(ICElement element, IResourceDelta delta) {
    }
}

