/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class Util {
    private Util() {
    }

    public static StringBuffer getContent(IFile file) throws IOException {
        StringBuffer stringBuffer;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        try {
            char[] b = Util.getInputStreamAsCharArray(stream, -1, null);
            stringBuffer = new StringBuffer(b.length).append(b);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return stringBuffer;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = new char[]{};
            int contentsLength = 0;
            int charsRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + available];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((charsRead = reader.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += charsRead;
            } while (charsRead > 0);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static void save(StringBuffer buffer, IFile file) throws CoreException {
        byte[] bytes = buffer.toString().getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, true, null);
    }
}

