/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.Container;
import org.eclipse.cdt.internal.core.model.parser.BinaryFileAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class BinaryContainerAdapter
extends Container
implements IFolder {
    IBinaryParser.IBinaryArchive archive;
    long timestamp;
    ArrayList children;
    ArrayList phantomResources;

    public BinaryContainerAdapter(IBinaryParser.IBinaryArchive ar) {
        this.archive = ar;
        this.phantomResources = new ArrayList(0);
        this.children = new ArrayList(5);
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        IFile file = this.archive.getFile();
        if (file != null) {
            file.refreshLocal(depth, monitor);
        }
    }

    public IPath getFullPath() {
        IFile file = this.archive.getFile();
        if (file != null) {
            return file.getFullPath();
        }
        return new Path("");
    }

    public IContainer getParent() {
        IFile file = this.archive.getFile();
        if (file != null) {
            return file.getParent();
        }
        return null;
    }

    public int getType() {
        return 2;
    }

    public long getModificationStamp() {
        IFile file = this.archive.getFile();
        if (file != null) {
            return file.getModificationStamp();
        }
        return 0L;
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.delete((keepHistory ? 2 : 0) | (force ? 1 : 0), monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        IFile file = this.archive.getFile();
        if (file != null) {
            file.delete(updateFlags, monitor);
        }
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        IFile file = this.archive.getFile();
        if (file != null) {
            file.touch(monitor);
        }
    }

    public void create(boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        this.create(force ? 1 : 0, local, monitor);
    }

    public void create(int updateFlags, boolean local, IProgressMonitor monitor) throws CoreException {
    }

    public IFile getFile(IPath path) {
        IContainer container;
        IFile f = (IFile)this.findMember(path);
        if (f == null && (container = this.getParent()) != null && !this.phantomResources.contains(f = container.getFile(path))) {
            this.phantomResources.add(f);
            this.phantomResources.trimToSize();
        }
        return f;
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.move(destination, (keepHistory ? 2 : 0) | (force ? 1 : 0), monitor);
    }

    public boolean exists(IPath path) {
        if (this.getFullPath().equals((Object)path)) {
            IFile file = this.archive.getFile();
            if (file != null) {
                return file.exists();
            }
            return false;
        }
        return this.findMember(path) != null;
    }

    public IFolder getFolder(IPath path) {
        IFolder f = null;
        IContainer container = this.getParent();
        if (container != null && !this.phantomResources.contains(f = container.getFolder(path))) {
            this.phantomResources.add(f);
            this.phantomResources.trimToSize();
        }
        return f;
    }

    public IResource[] members(int memberFlags) throws CoreException {
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean includeTeamPrivateMember = (memberFlags & 2) != 0;
        ArrayList<IResource> aList = new ArrayList<IResource>();
        if (this.hasChanged()) {
            this.children.clear();
            IBinaryParser.IBinaryObject[] objects = this.archive.getObjects();
            int i = 0;
            while (i < objects.length) {
                this.children.add(new BinaryFileAdapter(this, objects[i]));
                ++i;
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            IResource child = (IResource)this.children.get(i);
            if (includeTeamPrivateMember && child.isTeamPrivateMember() || !child.isTeamPrivateMember()) {
                aList.add(child);
            }
            ++i;
        }
        if (includePhantoms) {
            aList.addAll(this.phantomResources);
        }
        return aList.toArray(new IResource[0]);
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        return new IFile[0];
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        IFile file = this.archive.getFile();
        if (file != null) {
            return file.getPersistentProperty(key);
        }
        return null;
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        IFile file = this.archive.getFile();
        if (file != null) {
            file.setPersistentProperty(key, value);
        }
    }

    public boolean exists() {
        IFile file = this.archive.getFile();
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    boolean hasChanged() {
        long modif = this.getModificationStamp();
        boolean changed = modif != this.timestamp;
        this.timestamp = modif;
        return changed;
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }
}

