/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleAction;
import org.eclipse.cdt.internal.ui.buildconsole.ClearConsoleAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleEvent;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.TextEditorAction;

public class BuildConsoleView
extends ViewPart
implements ISelectionListener,
IBuildConsoleListener {
    private IProject selProject;
    private Font fFont = null;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (BuildConsoleView.this.fTextViewer != null && event.getProperty().equals("consoleFont")) {
                BuildConsoleView.this.initializeWidgetFont(BuildConsoleView.this.fTextViewer.getTextWidget());
            }
        }
    };
    protected TextViewer fTextViewer;
    IBuildConsoleManager fConsoleManager;
    ClearConsoleAction fClearOutputAction;
    TextEditorAction fCopyAction;
    TextEditorAction fSelectAllAction;
    String origTitle;
    static /* synthetic */ Class class$0;

    public BuildConsoleView() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fConsoleManager = CUIPlugin.getDefault().getConsoleManager();
    }

    private void initializeActions() {
        ResourceBundle bundle = CUIPlugin.getResourceBundle();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fClearOutputAction = new ClearConsoleAction(this);
        this.fCopyAction = new BuildConsoleAction(bundle, "Editor.Copy.", this.fTextViewer, 4);
        this.fSelectAllAction = new BuildConsoleAction(bundle, "Editor.SelectAll.", this.fTextViewer, 7);
        actionBars.setGlobalActionHandler("copy", (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
        this.fTextViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BuildConsoleView.this.fCopyAction.update();
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.fTextViewer = new TextViewer(parent, 834);
        this.fTextViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                BuildConsoleView.this.revealEndOfDocument();
            }
        });
        this.fTextViewer.setEditable(false);
        this.origTitle = this.getTitle();
        this.initializeWidgetFont(this.fTextViewer.getTextWidget());
        this.initializeActions();
        this.initializeContextMenu(this.fTextViewer.getControl());
        this.initializeToolBar();
        WorkbenchHelp.setHelp((Control)this.fTextViewer.getControl(), (String)"org.eclipse.cdt.ui.clear_console_view_context");
        this.setProject(this.getSite().getPage().getSelection());
        this.setDocument();
        this.setTitle();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.fConsoleManager.addConsoleListener(this);
    }

    protected void setProject(ISelection selection) {
        this.selProject = this.convertSelectionToProject(selection);
    }

    protected void setProject(IProject project) {
        this.selProject = project;
    }

    protected IProject getProject() {
        return this.selProject;
    }

    protected IDocument setDocument() {
        IProject project = this.getProject();
        if (project != null) {
            this.fTextViewer.setDocument(this.fConsoleManager.getConsoleDocument(project));
        }
        return null;
    }

    protected void setTitle() {
        String title = this.origTitle;
        IProject project = this.getProject();
        if (project != null) {
            title = String.valueOf(title) + " [" + project.getName() + "]";
        }
        this.setTitle(title);
    }

    protected void initializeWidgetFont(StyledText styledText) {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        String prefKey = "consoleFont";
        FontData data = null;
        data = store.contains(prefKey) && !store.isDefault(prefKey) ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)prefKey) : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)prefKey);
        if (data != null) {
            Font font = new Font((Device)styledText.getDisplay(), data);
            styledText.setFont(font);
            if (this.fFont != null) {
                this.fFont.dispose();
            }
            this.fFont = font;
        } else {
            styledText.setFont(JFaceResources.getTextFont());
        }
    }

    public void setFocus() {
        this.fTextViewer.getControl().setFocus();
    }

    protected void initializeContextMenu(Control parent) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuildConsoleView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(parent);
        parent.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.fCopyAction.update();
        menu.add((IAction)this.fCopyAction);
        menu.add((IAction)this.fSelectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fClearOutputAction);
    }

    private void initializeToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.fClearOutputAction);
        actionBars.updateActionBars();
    }

    protected void revealEndOfDocument() {
        IDocument doc = this.fTextViewer.getDocument();
        int docLength = doc.getLength();
        if (docLength > 0) {
            this.fTextViewer.revealRange(docLength - 1, 1);
            StyledText widget = this.fTextViewer.getTextWidget();
            widget.setCaretOffset(docLength);
            widget.showSelection();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.fConsoleManager.removeConsoleListener(this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject newProject = this.convertSelectionToProject(selection);
        IProject oldProject = this.getProject();
        if (oldProject == null || newProject != null && !newProject.equals((Object)oldProject)) {
            this.setProject(newProject);
            this.setDocument();
            this.setTitle();
        }
    }

    public void consoleChange(IBuildConsoleEvent event) {
        if (event.getType() == 1 || event.getType() == 2) {
            Display display = this.fTextViewer.getControl().getDisplay();
            this.selProject = event.getProject();
            if (event.getType() == 2 && this.selProject != event.getProject()) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    BuildConsoleView.this.setDocument();
                    BuildConsoleView.this.setTitle();
                }
            });
        }
    }

    IProject convertSelectionToProject(ISelection selection) {
        IProject project;
        block9: {
            project = null;
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                return project;
            }
            try {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                IAdaptable input = (IAdaptable)ssel.getFirstElement();
                if (input == null) break block9;
                IResource resource = null;
                if (input instanceof IResource) {
                    resource = (IResource)input;
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    resource = (IResource)input.getAdapter((Class)clazz);
                }
                if (resource != null) {
                    project = resource.getProject();
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return project;
    }

    void clear() {
        if (this.selProject != null) {
            this.fConsoleManager.getConsole(this.selProject).clear();
        }
    }
}

