/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CReconcilingStrategy
implements IReconcilingStrategy {
    private CContentOutlinePage fOutliner;
    private int fLastRegionOffset;
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;

    public CReconcilingStrategy(CEditor editor) {
        this.fOutliner = editor.getOutlinePage();
        this.fLastRegionOffset = Integer.MAX_VALUE;
        this.fEditor = editor;
        this.fManager = CUIPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = CUIPlugin.getDefault().getDocumentProvider();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void reconcile(IRegion region) {
        if (region.getOffset() <= this.fLastRegionOffset) {
            this.reconcile();
        }
        this.fLastRegionOffset = region.getOffset();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
    }

    private void reconcile() {
        try {
            ITranslationUnit tu = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (tu != null && tu.isWorkingCopy()) {
                IWorkingCopy workingCopy;
                IWorkingCopy iWorkingCopy = workingCopy = (IWorkingCopy)tu;
                synchronized (iWorkingCopy) {
                    workingCopy.reconcile(true, this.fProgressMonitor);
                }
            }
            this.fOutliner.contentUpdated();
        }
        catch (CModelException cModelException) {}
    }
}

