/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class CppCodeScanner
extends AbstractCScanner {
    private static String[] fgKeywords = new String[]{"and", "and_eq", "asm", "auto", "bitand", "bitor", "break", "case", "catch", "class", "compl", "const", "const_cast", "continue", "default", "delete", "do", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "final", "finally", "for", "friend", "goto", "if", "inline", "mutable", "namespace", "new", "not", "not_eq", "operator", "or", "or_eq", "private", "protected", "public", "redeclared", "register", "reinterpret_cast", "return", "restrict", "sizeof", "static", "static_cast", "struct", "switch", "template", "this", "throw", "true", "try", "typedef", "typeid", "typename", "union", "using", "virtual", "volatile", "while", "xor", "xor_eq"};
    private static String[] fgTypes = new String[]{"bool", "char", "double", "float", "int", "long", "short", "signed", "unsigned", "void", "wchar_t", "_Bool", "_Complex", "_Imaginary"};
    private static String[] fgConstants = new String[]{"false", "NULL", "true", "__DATE__", "__LINE__", "__TIME__", "__FILE__", "__STDC__"};
    private static String[] fgPreprocessor = new String[]{"#define", "#undef", "#include", "#error", "#warning", "#pragma", "#ifdef", "#ifndef", "#line", "#undef", "#if", "#else", "#elif", "#endif"};
    private static String[] fgTokenProperties = new String[]{"c_keyword", "c_type", "c_string", "c_default"};

    public CppCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("c_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        token = this.getToken("c_default");
        CWordRule wordRule = new CWordRule(new CWordDetector(), (IToken)token);
        token = this.getToken("c_keyword");
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("c_type");
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgPreprocessor.length) {
            wordRule.addWord(fgPreprocessor[i], (IToken)token);
            ++i;
        }
        rules.add(wordRule);
        int i2 = 0;
        while (i2 < fgPreprocessor.length) {
            PatternRule patternRule = new PatternRule(fgPreprocessor[i2], " ", (IToken)this.getToken("c_type"), '\u0000', true);
            patternRule.setColumnConstraint(0);
            ++i2;
        }
        this.setDefaultReturnToken((IToken)this.getToken("c_default"));
        return rules;
    }

    public void setRules(IRule[] rules) {
        super.setRules(rules);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private class CWordRule
    implements IRule {
        protected static final int UNDEFINED = -1;
        protected IWordDetector fDetector;
        protected IToken fDefaultToken;
        protected int fColumn = -1;
        protected Map fWords = new HashMap();
        private StringBuffer fBuffer = new StringBuffer();

        public CWordRule(IWordDetector detector) {
            this(detector, Token.UNDEFINED);
        }

        public CWordRule(IWordDetector detector, IToken defaultToken) {
            Assert.isNotNull((Object)detector);
            Assert.isNotNull((Object)defaultToken);
            this.fDetector = detector;
            this.fDefaultToken = defaultToken;
        }

        public void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            this.fWords.put(word, token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if (Character.isJavaIdentifierStart((char)c) || c == 35 && scanner.getColumn() == 1) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = scanner.read())));
                scanner.unread();
                IToken token = (IToken)this.fWords.get(this.fBuffer.toString());
                if (token != null) {
                    return token;
                }
                return this.fDefaultToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        public void setColumnConstraint(int column) {
            if (column < 0) {
                column = -1;
            }
            this.fColumn = column;
        }

        protected void unreadBuffer(ICharacterScanner scanner) {
            int i = this.fBuffer.length() - 1;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
        }
    }
}

