/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.ErrorTickAdornmentProvider;
import org.eclipse.cdt.internal.ui.IAdornmentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementLabelProvider
extends LabelProvider {
    private ImageRegistry fImageRegistry = CUIPlugin.getDefault().getImageRegistry();
    private WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();
    private CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    private IAdornmentProvider[] fAdornmentProviders;
    private int fImageFlags;
    private int fTextFlags;

    public CElementLabelProvider() {
        this(0, 1, null);
    }

    public CElementLabelProvider(int textFlags, int imageFlags, IAdornmentProvider[] adormentProviders) {
        this.fAdornmentProviders = adormentProviders;
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
    }

    public String getText(Object element) {
        if (element instanceof ICElement) {
            ICElement celem = (ICElement)element;
            StringBuffer name = new StringBuffer();
            switch (celem.getElementType()) {
                case 69: 
                case 74: 
                case 75: {
                    IVariableDeclaration vDecl = (IVariableDeclaration)celem;
                    name.append(vDecl.getElementName());
                    if (vDecl.getTypeName() == null || vDecl.getTypeName().length() <= 0) break;
                    name.append(" : ");
                    name.append(vDecl.getTypeName());
                    break;
                }
                case 67: 
                case 68: 
                case 70: 
                case 71: {
                    IFunctionDeclaration fDecl = (IFunctionDeclaration)celem;
                    name.append(fDecl.getSignature());
                    if (fDecl.getReturnType() == null || fDecl.getReturnType().length() <= 0) break;
                    name.append(" : ");
                    name.append(fDecl.getReturnType());
                    break;
                }
                case 63: 
                case 65: 
                case 66: {
                    if (celem.getElementName() != null && celem.getElementName().length() > 0) {
                        name.append(celem.getElementName());
                        break;
                    }
                    if (!(celem instanceof IVariableDeclaration)) break;
                    IVariableDeclaration varDecl = (IVariableDeclaration)celem;
                    name.append(varDecl.getTypeName());
                    break;
                }
                case 78: {
                    ITypeDef tDecl = (ITypeDef)celem;
                    name.append(tDecl.getElementName());
                    if (tDecl.getTypeName() == null || tDecl.getTypeName().length() <= 0) break;
                    name.append(" : ");
                    name.append(tDecl.getTypeName());
                    break;
                }
                case 61: {
                    if (celem.getElementName() != null && celem.getElementName().length() > 0) {
                        name.append(celem.getElementName());
                        break;
                    }
                    if (!(celem instanceof INamespace)) break;
                    INamespace nDecl = (INamespace)celem;
                    name.append(nDecl.getTypeName());
                    break;
                }
                case 73: 
                case 80: 
                case 81: {
                    ITemplate template = (ITemplate)celem;
                    String signature = template.getTemplateSignature();
                    name.append(signature);
                    break;
                }
                default: {
                    name.append(celem.getElementName());
                }
            }
            if (celem instanceof IBinary) {
                IBinary bin = (IBinary)celem;
                name.append(" - [" + bin.getCPU() + (bin.isLittleEndian() ? "le" : "be") + "]");
            }
            return name.toString();
        }
        return this.fWorkbenchLabelProvider.getText(element);
    }

    public Image getImage(Object element) {
        Image result;
        int imageFlags = this.getImageFlags();
        if (this.fAdornmentProviders != null) {
            int i = 0;
            while (i < this.fAdornmentProviders.length) {
                imageFlags |= this.fAdornmentProviders[i].computeAdornmentFlags(element);
                ++i;
            }
        }
        if (element instanceof ICElement && (result = this.fImageLabelProvider.getImageLabel(element, imageFlags)) != null) {
            return result;
        }
        return this.fWorkbenchLabelProvider.getImage(element);
    }

    public void dispose() {
        if (this.fAdornmentProviders != null) {
            int i = 0;
            while (i < this.fAdornmentProviders.length) {
                this.fAdornmentProviders[i].dispose();
                ++i;
            }
        }
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
            this.fWorkbenchLabelProvider = null;
        }
        this.fImageRegistry = null;
        if (this.fImageLabelProvider != null) {
            this.fImageLabelProvider.dispose();
        }
    }

    public void setTextFlags(int textFlags) {
        this.fTextFlags = textFlags;
    }

    public void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public int getImageFlags() {
        return this.fImageFlags;
    }

    public int getTextFlags() {
        return this.fTextFlags;
    }

    public static IAdornmentProvider[] getAdornmentProviders(boolean errortick, IAdornmentProvider extra) {
        if (errortick) {
            if (extra == null) {
                return new IAdornmentProvider[]{new ErrorTickAdornmentProvider()};
            }
            return new IAdornmentProvider[]{new ErrorTickAdornmentProvider(), extra};
        }
        if (extra != null) {
            return new IAdornmentProvider[]{extra};
        }
        return null;
    }
}

