/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecAbort;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowExitCode;
import org.eclipse.cdt.debug.mi.core.command.MIInfoProgram;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowExitCodeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoProgramInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.Spawner;

public class MIInferior
extends Process {
    static final int SUSPENDED = 1;
    static final int RUNNING = 2;
    static final int TERMINATED = 4;
    boolean connected = false;
    int exitCode = 0;
    int state = 0;
    MISession session;
    OutputStream out;
    InputStream in;
    PipedOutputStream inPiped;
    PipedInputStream err;
    PipedOutputStream errPiped;
    PTY pty;
    int inferiorPid;

    MIInferior(MISession mi, PTY p) {
        this.session = mi;
        this.pty = p;
        if (this.pty != null) {
            this.out = this.pty.getOutputStream();
            this.in = this.pty.getInputStream();
        }
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    this.buf.append((char)b);
                    if (b == 10) {
                        this.flush();
                    }
                }

                public void flush() throws IOException {
                    CLICommand cmd = new CLICommand(this, this.buf.toString()){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void setToken(int token) {
                        }
                    };
                    try {
                        MIInferior.this.session.postCommand(cmd);
                    }
                    catch (MIException mIException) {
                        throw new IOException("no mi session");
                    }
                }
            };
        }
        return this.out;
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            try {
                this.inPiped = new PipedOutputStream();
                this.in = new PipedInputStream(this.inPiped);
            }
            catch (IOException iOException) {}
        }
        return this.in;
    }

    public InputStream getErrorStream() {
        if (this.err == null) {
            try {
                this.errPiped = new PipedOutputStream();
                this.err = new PipedInputStream(this.errPiped);
            }
            catch (IOException iOException) {}
        }
        return this.err;
    }

    public int waitFor() throws InterruptedException {
        if (!this.isTerminated()) {
            MIInferior mIInferior = this;
            synchronized (mIInferior) {
                this.wait();
            }
        }
        return this.exitValue();
    }

    public int exitValue() {
        if (this.isTerminated()) {
            if (!this.session.isTerminated()) {
                CommandFactory factory = this.session.getCommandFactory();
                MIGDBShowExitCode code = factory.createMIGDBShowExitCode();
                try {
                    this.session.postCommand(code);
                    MIGDBShowExitCodeInfo info = code.getMIGDBShowExitCodeInfo();
                    this.exitCode = info.getCode();
                }
                catch (MIException mIException) {}
            }
            return this.exitCode;
        }
        throw new IllegalThreadStateException();
    }

    public void destroy() {
        if (this.session.isAttachSession() && this.isConnected() || this.session.isProgramSession() && !this.isTerminated()) {
            CommandFactory factory = this.session.getCommandFactory();
            MIExecAbort abort = factory.createMIExecAbort();
            try {
                this.interrupt();
                this.session.postCommand(abort);
                abort.getMIInfo();
                this.setTerminated(abort.getToken(), true);
            }
            catch (MIException mIException) {}
        }
    }

    public void interrupt() throws MIException {
        Process gdb = this.session.getGDBProcess();
        if (gdb instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)gdb;
            gdbSpawner.interrupt();
            int i = 0;
            while (this.isRunning() && i < 5) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            if (this.isRunning() && this.inferiorPid > 0) {
                gdbSpawner.raise(this.inferiorPid, gdbSpawner.INT);
            }
            i = 0;
            while (this.isRunning() && i < 5) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        } else {
            throw new MIException("Interruption no supported");
        }
    }

    public synchronized boolean isSuspended() {
        return this.state == 1;
    }

    public synchronized boolean isRunning() {
        return this.state == 2;
    }

    public synchronized boolean isTerminated() {
        return this.state == 4;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected() {
        this.connected = true;
    }

    public synchronized void setDisconnected() {
        this.connected = false;
    }

    public synchronized void setSuspended() {
        this.state = 1;
    }

    public synchronized void setRunning() {
        this.state = 2;
    }

    public synchronized void setTerminated() {
        this.setTerminated(0, false);
    }

    synchronized void setTerminated(int token, boolean fireEvent) {
        this.state = 4;
        try {
            if (this.inPiped != null) {
                this.inPiped.close();
                this.inPiped = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.errPiped != null) {
                this.errPiped.close();
                this.errPiped = null;
            }
        }
        catch (IOException iOException) {}
        if (this.pty != null) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
        }
        if (fireEvent) {
            this.session.fireEvent(new MIInferiorExitEvent(token));
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.inPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.errPiped;
    }

    public PTY getPTY() {
        return this.pty;
    }

    public void update() {
        if (this.inferiorPid == 0) {
            if (!this.isConnected()) {
                CommandFactory factory = this.session.getCommandFactory();
                MIInfoProgram prog = factory.createMIInfoProgram();
                try {
                    this.session.postCommand(prog);
                    MIInfoProgramInfo info = prog.getMIInfoProgramInfo();
                    this.inferiorPid = info.getPID();
                }
                catch (MIException mIException) {}
            }
            if (this.inferiorPid == 0) {
                this.inferiorPid = -1;
            }
        }
    }
}

