/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Instruction;
import org.eclipse.cdt.debug.mi.core.cdi.model.MixedInstruction;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataDisassemble;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowDirectories;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIDataDisassembleInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowDirectoriesInfo;
import org.eclipse.cdt.debug.mi.core.output.MISrcAsm;

public class SourceManager
extends SessionObject
implements ICDISourceManager {
    boolean autoupdate = false;

    public SourceManager(Session session) {
        super(session);
    }

    public void addSourcePaths(String[] dirs) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIEnvironmentDirectory dir = factory.createMIEnvironmentDirectory(dirs);
        try {
            mi.postCommand(dir);
            dir.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public String[] getSourcePaths() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowDirectories dir = factory.createMIGDBShowDirectories();
        try {
            mi.postCommand(dir);
            MIGDBShowDirectoriesInfo info = dir.getMIGDBShowDirectoriesInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataDisassemble dis = factory.createMIDataDisassemble(filename, linenum, lines, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(session.getCurrentTarget(), asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws CDIException {
        return this.getInstructions(filename, linenum, -1);
    }

    public ICDIInstruction[] getInstructions(long start, long end) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String hex = "0x";
        String sa = String.valueOf(hex) + Long.toHexString(start);
        String ea = String.valueOf(hex) + Long.toHexString(end);
        MIDataDisassemble dis = factory.createMIDataDisassemble(sa, ea, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(session.getCurrentTarget(), asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataDisassemble dis = factory.createMIDataDisassemble(filename, linenum, lines, true);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MISrcAsm[] srcAsm = info.getMISrcAsms();
            ICDIMixedInstruction[] mixed = new ICDIMixedInstruction[srcAsm.length];
            int i = 0;
            while (i < mixed.length) {
                mixed[i] = new MixedInstruction(session.getCurrentTarget(), srcAsm[i]);
                ++i;
            }
            return mixed;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws CDIException {
        return this.getMixedInstructions(filename, linenum, -1);
    }

    public ICDIMixedInstruction[] getMixedInstructions(long start, long end) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String hex = "0x";
        String sa = String.valueOf(hex) + Long.toHexString(start);
        String ea = String.valueOf(hex) + Long.toHexString(end);
        MIDataDisassemble dis = factory.createMIDataDisassemble(sa, ea, true);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MISrcAsm[] srcAsm = info.getMISrcAsms();
            ICDIMixedInstruction[] mixed = new ICDIMixedInstruction[srcAsm.length];
            int i = 0;
            while (i < mixed.length) {
                mixed[i] = new MixedInstruction(session.getCurrentTarget(), srcAsm[i]);
                ++i;
            }
            return mixed;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public void update() throws CDIException {
    }
}

