/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;

public class Register
extends Variable
implements ICDIRegister {
    public Register(RegisterObject obj, MIVar var) {
        super(obj, var);
    }

    public RegisterObject getRegisterObject() {
        return (RegisterObject)super.getVariableObject();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            this.value = new RegisterValue(this);
        }
        return this.value;
    }

    public void setValue(String expression) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.getMIVar().getVarName(), expression);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MIRegisterChangedEvent change = new MIRegisterChangedEvent(0, this.getName(), this.getVariableObject().getPosition());
        mi.fireEvent(change);
        ICDIRegisterManager mgr = session.getRegisterManager();
        if (mgr.isAutoUpdate()) {
            mgr.update();
        }
    }
}

