/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterManager
extends CUpdateManager
implements ICRegisterManager {
    private List fRegisterGroups;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CRegisterManager(CDebugTarget target) {
        super(target);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.removeAllRegisterGroups();
    }

    public void addRegisterGroup(IRegisterGroup group) {
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    public void initialize() {
        this.fRegisterGroups = new ArrayList(20);
        boolean autoRefresh = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(autoRefresh);
        }
        this.createMainRegisterGroup();
    }

    public void removeAllRegisterGroups() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).dispose();
        }
        this.fRegisterGroups.clear();
    }

    public void removeRegisterGroup(IRegisterGroup group) {
        this.fRegisterGroups.remove(group);
    }

    private void createMainRegisterGroup() {
        ICDIRegisterObject[] regObjects = null;
        try {
            regObjects = this.getDebugTarget().getCDISession().getRegisterManager().getRegisterObjects();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        if (regObjects != null) {
            this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), "Main", regObjects));
        }
    }

    public void reset() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).resetChangeFlags();
        }
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getRegisterManager();
        }
        return null;
    }
}

