/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.IDummyStackFrame;
import org.eclipse.cdt.debug.core.model.IInstructionStep;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.model.IState;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDummyStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class CThread
extends CDebugElement
implements IThread,
IState,
IRestart,
IInstructionStep,
IResumeWithoutSignal,
ISwitchToFrame,
ICDIEventListener {
    private static final int MAX_STACK_DEPTH = 100;
    private ICDIThread fCDIThread;
    private ArrayList fStackFrames;
    private boolean fRunning;
    private boolean fRefreshChildren = true;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private ICDIConfiguration fConfig;
    private boolean fIsCurrent = false;
    private CStackFrame fLastStackFrame = null;
    private int fLastStackDepth = 0;
    private boolean fDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CThread(CDebugTarget target, ICDIThread cdiThread) {
        super(target);
        this.setCDIThread(cdiThread);
        this.fConfig = this.getCDISession().getConfiguration();
        this.initialize();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.fStackFrames = new ArrayList();
        this.setRunning(false);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = this.computeStackFrames();
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        try {
            return this.computeStackFrames().size() > 0;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = new ArrayList();
            } else if (refreshChildren) {
                ICDIStackFrame[] frames;
                int depth;
                Object frame;
                if (this.fStackFrames.size() > 0 && (frame = this.fStackFrames.get(this.fStackFrames.size() - 1)) instanceof IDummyStackFrame) {
                    ((AbstractCollection)this.fStackFrames).remove(frame);
                }
                ICDIStackFrame[] iCDIStackFrameArray = (depth = this.getStackDepth()) != 0 ? this.getCDIStackFrames(0, depth > this.getMaxStackDepth() ? this.getMaxStackDepth() - 1 : depth - 1) : (frames = new ICDIStackFrame[]{});
                if (this.fStackFrames.isEmpty()) {
                    this.addStackFrames(frames, 0, frames.length);
                } else if (depth < this.getLastStackDepth()) {
                    this.disposeStackFrames(0, this.getLastStackDepth() - depth);
                    this.updateStackFrames(frames, 0, this.fStackFrames, this.fStackFrames.size());
                    if (this.fStackFrames.size() < frames.length) {
                        this.addStackFrames(frames, this.fStackFrames.size(), frames.length - this.fStackFrames.size());
                    }
                } else if (depth > this.getLastStackDepth()) {
                    this.disposeStackFrames(frames.length - depth + this.getLastStackDepth(), depth - this.getLastStackDepth());
                    this.addStackFrames(frames, 0, depth - this.getLastStackDepth());
                    this.updateStackFrames(frames, depth - this.getLastStackDepth(), this.fStackFrames, frames.length - depth + this.getLastStackDepth());
                } else if (depth != 0) {
                    ICDIStackFrame oldTopFrame;
                    ICDIStackFrame newTopFrame = frames.length > 0 ? frames[0] : null;
                    ICDIStackFrame iCDIStackFrame = oldTopFrame = this.fStackFrames.size() > 0 ? ((CStackFrame)this.fStackFrames.get(0)).getLastCDIStackFrame() : null;
                    if (!CStackFrame.equalFrame(newTopFrame, oldTopFrame)) {
                        this.disposeStackFrames(0, this.fStackFrames.size());
                        this.addStackFrames(frames, 0, frames.length);
                    } else {
                        this.updateStackFrames(frames, 0, this.fStackFrames, frames.length);
                    }
                }
                if (depth > this.getMaxStackDepth()) {
                    this.fStackFrames.add(new CDummyStackFrame(this));
                }
                this.setLastStackDepth(depth);
                this.setRefreshChildren(false);
            }
        }
        return this.fStackFrames;
    }

    protected ICDIStackFrame[] getCDIStackFrames() throws DebugException {
        return new ICDIStackFrame[0];
    }

    protected ICDIStackFrame[] getCDIStackFrames(int lowFrame, int highFrame) throws DebugException {
        try {
            return this.getCDIThread().getStackFrames(lowFrame, highFrame);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return new ICDIStackFrame[0];
        }
    }

    protected void updateStackFrames(ICDIStackFrame[] newFrames, int offset, List oldFrames, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            CStackFrame frame = (CStackFrame)oldFrames.get(offset);
            frame.setCDIStackFrame(newFrames[offset]);
            frame.fireChangeEvent(256);
            ++offset;
            ++i;
        }
    }

    protected void addStackFrames(ICDIStackFrame[] newFrames, int startIndex, int length) {
        if (newFrames.length >= startIndex + length) {
            int i = 0;
            while (i < length) {
                this.fStackFrames.add(i, new CStackFrame(this, newFrames[startIndex + i]));
                ++i;
            }
        }
    }

    public List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames(int depth, ICDIStackFrame[] frames) throws DebugException {
        ArrayList<CDebugElement> list = new ArrayList<CDebugElement>(frames.length);
        int i = 0;
        while (i < frames.length) {
            list.add(new CStackFrame(this, frames[i]));
            ++i;
        }
        if (depth > frames.length) {
            list.add(new CDummyStackFrame(this));
        }
        return list;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List c = this.computeStackFrames();
        return c.isEmpty() ? null : (IStackFrame)c.get(0);
    }

    public String getName() throws DebugException {
        return this.getCDIThread().toString();
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    public void handleDebugEvent(ICDIEvent event) {
        if (this.isDisposed()) {
            return;
        }
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDISuspendedEvent) {
                if (source instanceof ICDIThread && this.getCDIThread().equals((ICDIThread)source) || source instanceof ICDITarget) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)event);
                }
            } else if (event instanceof ICDIResumedEvent) {
                if (source instanceof ICDIThread && source.equals(this.getCDIThread()) || source instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleTerminatedEvent((ICDIDestroyedEvent)event);
                }
            } else if (event instanceof ICDIDisconnectedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                }
            } else if (event instanceof ICDIChangedEvent && source instanceof ICDIThread) {
                this.handleChangedEvent((ICDIChangedEvent)event);
            }
        }
    }

    public boolean canResume() {
        return this.fConfig.supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.fConfig.supportsSuspend() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return !this.fRunning && !this.isTerminated();
    }

    public void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        try {
            this.getCDIThread().resume();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            this.getCDIThread().suspend();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.fConfig.supportsStepping() && this.isSuspended() && this.getTopStackFrame() != null;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean isStepping() {
        return this.getCurrentStateId() == 6;
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        ((CDebugTarget)this.getDebugTarget()).setBreakpoints();
        try {
            if (this.getRealSourceMode() == 0) {
                this.getCDIThread().stepInto();
            } else {
                this.getCDIThread().stepIntoInstruction();
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        ((CDebugTarget)this.getDebugTarget()).setBreakpoints();
        try {
            if (this.getRealSourceMode() == 0) {
                this.getCDIThread().stepOver();
            } else {
                this.getCDIThread().stepOverInstruction();
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        ((CDebugTarget)this.getDebugTarget()).setBreakpoints();
        try {
            this.getCDIThread().stepReturn();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setCDIThread(ICDIThread cdiThread) {
        this.fCDIThread = cdiThread;
    }

    protected ICDIThread getCDIThread() {
        return this.fCDIThread;
    }

    protected void setRunning(boolean running) {
        this.fRunning = running;
    }

    protected synchronized void preserveStackFrames() {
        Iterator it = ((AbstractList)this.fStackFrames).iterator();
        while (it.hasNext()) {
            CStackFrame frame;
            IAdaptable iAdaptable = (IAdaptable)it.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (CStackFrame)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            frame.preserve();
        }
        this.setRefreshChildren(true);
    }

    protected synchronized void disposeStackFrames() {
        Iterator it = ((AbstractList)this.fStackFrames).iterator();
        while (it.hasNext()) {
            CStackFrame frame;
            IAdaptable iAdaptable = (IAdaptable)it.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (CStackFrame)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            frame.dispose();
        }
        this.fStackFrames.clear();
        this.setLastStackDepth(0);
        this.setRefreshChildren(true);
    }

    protected void disposeStackFrames(int index, int length) {
        ArrayList<CStackFrame> removeList = new ArrayList<CStackFrame>(length);
        Iterator it = ((AbstractList)this.fStackFrames).iterator();
        int counter = 0;
        while (it.hasNext()) {
            CStackFrame frame;
            IAdaptable iAdaptable = (IAdaptable)it.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (CStackFrame)iAdaptable.getAdapter((Class)clazz)) != null && counter >= index && counter < index + length) {
                frame.dispose();
                removeList.add(frame);
            }
            ++counter;
        }
        ((AbstractCollection)this.fStackFrames).removeAll(removeList);
    }

    protected void terminated() {
        this.setRunning(false);
        this.dispose();
        this.cleanup();
        this.fireTerminateEvent();
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int id) {
        this.fCurrentStateId = id;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object info) {
        this.fCurrentStateInfo = info;
    }

    public boolean canStepIntoInstruction() {
        return this.canStepInto();
    }

    public boolean canStepOverInstruction() {
        return this.canStepOver();
    }

    public void stepIntoInstruction() throws DebugException {
        if (!this.canStepIntoInstruction()) {
            return;
        }
        ((CDebugTarget)this.getDebugTarget()).setBreakpoints();
        try {
            this.getCDIThread().stepIntoInstruction();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void stepOverInstruction() throws DebugException {
        if (!this.canStepOverInstruction()) {
            return;
        }
        ((CDebugTarget)this.getDebugTarget()).setBreakpoints();
        try {
            this.getCDIThread().stepOverInstruction();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        this.setRunning(false);
        if (event.getSource() instanceof ICDITarget) {
            if (this.isCurrent()) {
                this.setCurrentStateId(7);
                ICDISessionObject reason = event.getReason();
                this.setCurrentStateInfo(reason);
                if (reason instanceof ICDIEndSteppingRange) {
                    this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
                } else if (reason instanceof ICDIBreakpoint) {
                    this.handleBreakpointHit((ICDIBreakpoint)((Object)reason));
                } else if (reason instanceof ICDISignalReceived) {
                    this.handleSuspendedBySignal((ICDISignalReceived)reason);
                } else {
                    this.fireSuspendEvent(32);
                }
            }
            return;
        }
        this.setCurrentStateId(7);
        this.setCurrentStateInfo(null);
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setRunning(true);
        this.setLastStackFrame(null);
        int state = 5;
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 1;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        if (this.isCurrent() && event.getType() != 0) {
            this.preserveStackFrames();
            state = 6;
        } else {
            this.disposeStackFrames();
            state = 5;
        }
        this.setCurrentStateId(state);
        this.setCurrentStateInfo(null);
        this.fireResumeEvent(detail);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(8);
    }

    private void handleBreakpointHit(ICDIBreakpoint breakpoint) {
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setCurrentStateId(10);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    protected void cleanup() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
    }

    protected synchronized void stepToFrame(IStackFrame frame) throws DebugException {
    }

    private void setRefreshChildren(boolean refresh) {
        this.fRefreshChildren = refresh;
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected void setCurrent(boolean current) {
        this.fIsCurrent = current;
    }

    public void switchToFrame(IStackFrame frame) throws DebugException {
        if (frame == null || !(frame instanceof CStackFrame) || frame.equals(this.getLastStackFrame())) {
            return;
        }
        try {
            if (this.getLastStackFrame() != null) {
                ((CDebugTarget)this.getDebugTarget()).resetRegisters();
                this.getCDIThread().setCurrentStackFrame(((CStackFrame)frame).getCDIStackFrame());
            }
            this.setLastStackFrame((CStackFrame)frame);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    private int getRealSourceMode() {
        return ((CDebugTarget)this.getDebugTarget()).getRealSourceMode();
    }

    private void setLastStackFrame(CStackFrame frame) {
        this.fLastStackFrame = frame;
    }

    private CStackFrame getLastStackFrame() {
        return this.fLastStackFrame;
    }

    protected int getStackDepth() throws DebugException {
        int depth = 0;
        try {
            depth = this.getCDIThread().getStackFrameCount();
        }
        catch (CDIException e) {
            MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, "Stack is not available.", null);
            status.add((IStatus)new Status(4, status.getPlugin(), status.getCode(), e.getMessage(), null));
            CDebugUtils.error((IStatus)status, this.getDebugTarget());
        }
        return depth;
    }

    protected int getMaxStackDepth() {
        return 100;
    }

    private void setLastStackDepth(int depth) {
        this.fLastStackDepth = depth;
    }

    private int getLastStackDepth() {
        return this.fLastStackDepth;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.fDisposed = true;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }
}

