/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.builder.model.ICTool;
import org.eclipse.cdt.core.builder.util.Filesystem;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class ACTool
implements ICTool {
    private String fTypeId;
    private String fToolId;
    private IPath fToolPath;

    public ACTool(String typeId, String id, IPath path) {
        this.fTypeId = typeId;
        this.fToolId = id;
        this.fToolPath = path;
    }

    public ACTool(String typeId, String id, String exeName) {
        this.fTypeId = typeId;
        this.fToolId = id;
        this.fToolPath = this.locateExe(exeName);
    }

    protected IPath locateExe(String name) {
        ICTool.IOResults ior = this.execHelper("which", new String[]{name}, null);
        if (ior.stdout.size() > 0) {
            return new Path(Filesystem.getNativePath(ior.stdout.toString().trim()));
        }
        return null;
    }

    protected void setPath(String path) {
        this.fToolPath = new Path(path);
    }

    protected ICTool.IOResults execHelper(String[] parameters, String workingDir) {
        return this.execHelper(this.fToolPath.toString(), parameters, new File(workingDir));
    }

    protected ICTool.IOResults execHelper(String exeName, String[] parameters, File dir) {
        ICTool.IOResults ior = new ICTool.IOResults();
        String[] cmds = new String[parameters.length + 1];
        cmds[0] = exeName;
        int i = 1;
        while (i < cmds.length) {
            cmds[i] = parameters[i - 1];
            ++i;
        }
        try {
            ProcessFactory pf = ProcessFactory.getFactory();
            Process pid = pf.exec(cmds, null, dir);
            ProcessClosure pc = new ProcessClosure(pid, ior.stdout, ior.stderr);
            pc.runBlocking();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ior;
    }

    public String getTypeId() {
        return this.fTypeId;
    }

    public String getId() {
        return this.fToolId;
    }

    public IPath getPath() {
        return (IPath)this.fToolPath.clone();
    }

    public boolean exists() {
        return this.fToolPath.toFile().exists();
    }

    public ICTool.IOResults exec(String[] parameters, String workingDir) {
        return this.execHelper(parameters, workingDir);
    }

    public abstract IErrorParser getErrorParser();
}

