/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.builder.model.ICToolchain;
import org.eclipse.cdt.core.builder.model.ICToolchainProvider;

public abstract class ACToolchainProvider
implements ICToolchainProvider {
    private Map fToolchainMap = new HashMap();

    public ACToolchainProvider() {
        this.doRefresh();
    }

    protected boolean toolchainExists(String id) {
        return this.fToolchainMap.containsKey(id);
    }

    protected void addToolchain(String id, ICToolchain tc) {
        this.fToolchainMap.put(id, tc);
    }

    protected ICToolchain getToolchainHelper(String id) {
        ICToolchain tc = null;
        Object obj = this.fToolchainMap.get(id);
        if (obj instanceof ICToolchain) {
            tc = (ICToolchain)obj;
        }
        return tc;
    }

    protected boolean removeToolchain(String id) {
        boolean exists = this.toolchainExists(id);
        if (exists) {
            this.fToolchainMap.remove(id);
        }
        return exists;
    }

    public ICToolchain getToolchain(String id) {
        return this.getToolchainHelper(id);
    }

    public ICToolchain[] getToolchains() {
        Collection tcc = this.fToolchainMap.values();
        return tcc.toArray(new ICToolchain[tcc.size()]);
    }

    public abstract void doRefresh();
}

