/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.model.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.builder.BuilderPlugin;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CBuildConfigInfo {
    private HashMap fAttributes;

    protected CBuildConfigInfo() {
        this.setAttributeTable(new HashMap(10));
    }

    private HashMap getAttributeTable() {
        return this.fAttributes;
    }

    private void setAttributeTable(HashMap table) {
        this.fAttributes = table;
    }

    protected String getStringAttribute(String key, String defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof String) {
                return (String)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Attribute_{0}_is_not_of_type_java.lang.String._1"), key), null));
        }
        return defaultValue;
    }

    protected int getIntAttribute(String key, int defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Integer) {
                return (Integer)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Attribute_{0}_is_not_of_type_int._2"), key), null));
        }
        return defaultValue;
    }

    protected boolean getBooleanAttribute(String key, boolean defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Boolean) {
                return (Boolean)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Attribute_{0}_is_not_of_type_boolean._3"), key), null));
        }
        return defaultValue;
    }

    protected List getListAttribute(String key, List defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof List) {
                return (List)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Attribute_{0}_is_not_of_type_java.util.List._1"), key), null));
        }
        return defaultValue;
    }

    protected Map getMapAttribute(String key, Map defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Map) {
                return (Map)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Attribute_{0}_is_not_of_type_java.util.Map._1"), key), null));
        }
        return defaultValue;
    }

    protected CBuildConfigInfo getCopy() {
        CBuildConfigInfo copy = new CBuildConfigInfo();
        copy.setAttributeTable((HashMap)this.getAttributeTable().clone());
        return copy;
    }

    protected void setAttribute(String key, Object value) {
        if (value == null) {
            this.getAttributeTable().remove(key);
        } else {
            this.getAttributeTable().put(key, value);
        }
    }

    protected String getAsXML() throws IOException {
        DocumentImpl doc = new DocumentImpl();
        Element configRootElement = doc.createElement("buildConfiguration");
        doc.appendChild(configRootElement);
        Iterator keys = this.getAttributeTable().keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.getAttributeTable().get(key);
            if (value == null) continue;
            Element element = null;
            String valueString = null;
            if (value instanceof String) {
                valueString = (String)value;
                element = this.createKeyValueElement((Document)doc, "stringAttribute", key, valueString);
            } else if (value instanceof Integer) {
                valueString = ((Integer)value).toString();
                element = this.createKeyValueElement((Document)doc, "intAttribute", key, valueString);
            } else if (value instanceof Boolean) {
                valueString = ((Boolean)value).toString();
                element = this.createKeyValueElement((Document)doc, "booleanAttribute", key, valueString);
            } else if (value instanceof List) {
                element = this.createListElement((Document)doc, "listAttribute", key, (List)value);
            } else if (value instanceof Map) {
                element = this.createMapElement((Document)doc, "mapAttribute", key, (Map)value);
            }
            configRootElement.appendChild(element);
        }
        return CBuildConfigManager.serializeDocument((Document)doc);
    }

    protected Element createKeyValueElement(Document doc, String elementType, String key, String value) {
        Element element = doc.createElement(elementType);
        element.setAttribute("key", key);
        element.setAttribute("value", value);
        return element;
    }

    protected Element createListElement(Document doc, String elementType, String listKey, List list) {
        Element listElement = doc.createElement(elementType);
        listElement.setAttribute("key", listKey);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            Element element = doc.createElement("listEntry");
            element.setAttribute("value", value);
            listElement.appendChild(element);
        }
        return listElement;
    }

    protected Element createMapElement(Document doc, String elementType, String mapKey, Map map) {
        Element mapElement = doc.createElement(elementType);
        mapElement.setAttribute("key", mapKey);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)map.get(key);
            Element element = doc.createElement("mapEntry");
            element.setAttribute("key", key);
            element.setAttribute("value", value);
            mapElement.appendChild(element);
        }
        return mapElement;
    }

    protected void initializeFromXML(Element root) throws CoreException {
        if (!root.getNodeName().equalsIgnoreCase("buildConfiguration")) {
            throw this.getInvalidFormatDebugException();
        }
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase("stringAttribute")) {
                    this.setStringAttribute(element);
                } else if (nodeName.equalsIgnoreCase("intAttribute")) {
                    this.setIntegerAttribute(element);
                } else if (nodeName.equalsIgnoreCase("booleanAttribute")) {
                    this.setBooleanAttribute(element);
                } else if (nodeName.equalsIgnoreCase("listAttribute")) {
                    this.setListAttribute(element);
                } else if (nodeName.equalsIgnoreCase("mapAttribute")) {
                    this.setMapAttribute(element);
                }
            }
            ++i;
        }
    }

    protected void setStringAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, value);
    }

    protected void setIntegerAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, new Integer(value));
    }

    protected void setBooleanAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, new Boolean(value));
    }

    protected void setListAttribute(Element element) throws CoreException {
        String listKey = element.getAttribute("key");
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        ArrayList<String> list = new ArrayList<String>(entryCount);
        int i = 0;
        while (i < entryCount) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element subElement = (Element)node;
                String nodeName = subElement.getNodeName();
                if (!nodeName.equalsIgnoreCase("listEntry")) {
                    throw this.getInvalidFormatDebugException();
                }
                String value = this.getValueAttribute(subElement);
                list.add(value);
            }
            ++i;
        }
        this.setAttribute(listKey, list);
    }

    protected void setMapAttribute(Element element) throws CoreException {
        String mapKey = element.getAttribute("key");
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashMap<String, String> map = new HashMap<String, String>(entryCount);
        int i = 0;
        while (i < entryCount) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element subElement = (Element)node;
                String nodeName = subElement.getNodeName();
                if (!nodeName.equalsIgnoreCase("mapEntry")) {
                    throw this.getInvalidFormatDebugException();
                }
                String key = this.getKeyAttribute(subElement);
                String value = this.getValueAttribute(subElement);
                map.put(key, value);
            }
            ++i;
        }
        this.setAttribute(mapKey, map);
    }

    protected String getKeyAttribute(Element element) throws CoreException {
        String key = element.getAttribute("key");
        if (key == null) {
            throw this.getInvalidFormatDebugException();
        }
        return key;
    }

    protected String getValueAttribute(Element element) throws CoreException {
        String value = element.getAttribute("value");
        if (value == null) {
            throw this.getInvalidFormatDebugException();
        }
        return value;
    }

    protected DebugException getInvalidFormatDebugException() {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.getString((String)"LaunchConfigurationInfo.Invalid_launch_configuration_XML._10"), null));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CBuildConfigInfo)) {
            return false;
        }
        CBuildConfigInfo other = (CBuildConfigInfo)obj;
        return this.compareAttributes(this.fAttributes, other.getAttributeTable());
    }

    protected boolean compareAttributes(HashMap map1, HashMap map2) {
        BuilderPlugin.getDefault().getBuildConfigurationManager();
        if (map1.size() == map2.size()) {
            Iterator attributes = map1.keySet().iterator();
            while (attributes.hasNext()) {
                String key = (String)attributes.next();
                Object attr1 = map1.get(key);
                Object attr2 = map2.get(key);
                if (attr2 == null) {
                    return false;
                }
                if (attr1.equals(attr2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

