/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.model.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.builder.model.ICBuildConfig;
import org.eclipse.cdt.core.builder.model.ICBuildConfigListener;
import org.eclipse.cdt.core.builder.model.ICBuildConfigManager;
import org.eclipse.cdt.core.builder.model.ICBuildConfigWorkingCopy;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfig;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigInfo;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigWorkingCopy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CBuildConfigManager
implements ICBuildConfigManager {
    private ListenerList fListeners = new ListenerList(5);
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int CHANGED = 2;

    public static String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }

    public void addListener(ICBuildConfigListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ICBuildConfigListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void addConfiguration(ICBuildConfig configuration) {
        this.fireUpdate(configuration, 0);
    }

    public void removeConfiguration(ICBuildConfig configuration) {
        this.fireUpdate(configuration, 1);
    }

    public String generateUniqueConfigurationNameFrom(IProject project, String baseName) {
        String trailer;
        int index = 1;
        int length = baseName.length();
        int copyIndex = baseName.lastIndexOf(" (");
        if (copyIndex > -1 && length > copyIndex + 2 && baseName.charAt(length - 1) == ')' && this.isNumber(trailer = baseName.substring(copyIndex + 2, length - 1))) {
            try {
                index = Integer.parseInt(trailer);
                baseName = baseName.substring(0, copyIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String newName = baseName;
        try {
            StringBuffer buffer = null;
            while (this.isExistingConfigurationName(project, newName)) {
                buffer = new StringBuffer(baseName);
                buffer.append(" (");
                buffer.append(String.valueOf(index));
                ++index;
                buffer.append(')');
                newName = buffer.toString();
            }
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        return newName;
    }

    public ICBuildConfig getConfiguration(IFile file) {
        return new CBuildConfig(file.getLocation());
    }

    public ICBuildConfig getConfiguration(String memento) throws CoreException {
        return new CBuildConfig(memento);
    }

    public ICBuildConfigWorkingCopy getConfiguration(IProject project, String name) {
        if (name == null || name.length() < 1) {
            name = "New Configuration";
        }
        name = this.generateUniqueConfigurationNameFrom(project, name);
        return new CBuildConfigWorkingCopy((IContainer)project, name);
    }

    public ICBuildConfig[] getConfigurations(IProject project) throws CoreException {
        List configs = this.findConfigurations((IContainer)project, "build");
        return configs.toArray(new ICBuildConfig[configs.size()]);
    }

    public boolean isExistingConfigurationName(IProject project, String name) throws CoreException {
        int count = 0;
        List configFiles = this.findConfigurations((IContainer)project, "build");
        count = configFiles.size();
        if (count > 0) {
            Iterator iter = configFiles.iterator();
            while (iter.hasNext()) {
                ICBuildConfig element = (ICBuildConfig)iter.next();
                if (!name.equals(element.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void fireUpdate(ICBuildConfig configuration, int update) {
        Object[] copiedListeners = this.fListeners.getListeners();
        int i = 0;
        while (i < copiedListeners.length) {
            ICBuildConfigListener listener = (ICBuildConfigListener)copiedListeners[i];
            switch (update) {
                case 0: {
                    listener.configurationAdded(configuration);
                    break;
                }
                case 1: {
                    listener.configurationRemoved(configuration);
                    break;
                }
                case 2: {
                    listener.configurationChanged(configuration);
                }
            }
            ++i;
        }
    }

    protected void configurationDeleted(ICBuildConfig configuration) throws CoreException {
        this.fireUpdate(configuration, 1);
    }

    protected void configurationAdded(ICBuildConfig configuration) throws CoreException {
        if (this.isValid(configuration)) {
            this.fireUpdate(configuration, 0);
        } else {
            this.fireUpdate(configuration, 0);
        }
    }

    protected void configurationChanged(ICBuildConfig configuration) {
        if (this.isValid(configuration)) {
            this.fireUpdate(configuration, 2);
        } else {
            this.fireUpdate(configuration, 1);
        }
    }

    protected CBuildConfigInfo getInfo(ICBuildConfig config) throws CoreException {
        CBuildConfigInfo info = null;
        if (config.exists()) {
            InputStream stream = null;
            try {
                try {
                    IFile file = ((CBuildConfig)config).getFile();
                    stream = file.getContents();
                    info = this.createInfoFromXML(stream);
                }
                catch (FileNotFoundException e) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                }
                catch (SAXException e) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                }
                catch (ParserConfigurationException e) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                }
                catch (IOException e) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                }
                throw throwable;
            }
            Object var5_11 = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString((String)"LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                }
            }
        } else {
            throw this.createDebugException(DebugCoreMessages.getString((String)"LaunchManager.Launch_configuration_does_not_exist._6"), null);
        }
        return info;
    }

    protected CBuildConfigInfo createInfoFromXML(InputStream stream) throws CoreException, ParserConfigurationException, IOException, SAXException {
        Element root = null;
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        root = parser.parse(new InputSource(stream)).getDocumentElement();
        CBuildConfigInfo info = new CBuildConfigInfo();
        info.initializeFromXML(root);
        return info;
    }

    protected DebugException createDebugException(String message, Throwable throwable) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, message, throwable));
    }

    protected List findConfigurations(IContainer container, String extension) throws CoreException {
        ArrayList list = new ArrayList(10);
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return list;
        }
        this.searchForFiles(container, extension, list);
        Iterator iter = list.iterator();
        ArrayList<ICBuildConfig> configs = new ArrayList<ICBuildConfig>(list.size());
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            configs.add(this.getConfiguration(file));
        }
        return configs;
    }

    protected void searchForFiles(IContainer container, String extension, List list) throws CoreException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IFile file;
            if (members[i] instanceof IContainer) {
                if (!(members[i] instanceof IProject) || ((IProject)members[i]).isOpen()) {
                    this.searchForFiles((IContainer)members[i], extension, list);
                }
            } else if (members[i] instanceof IFile && extension.equalsIgnoreCase((file = (IFile)members[i]).getFileExtension())) {
                list.add(file);
            }
            ++i;
        }
    }

    private boolean isNumber(String string) {
        int numChars = string.length();
        if (numChars == 0) {
            return false;
        }
        int i = 0;
        while (i < numChars) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isValid(ICBuildConfig config) {
        return config != null;
    }
}

