/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.internal.core.index.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class IndexModel {
    static IndexModel indexModel = null;
    static IndexManager manager = null;
    static final String INDEX_MODEL_ID = "org.eclipse.cdt.core.indexmodel";
    static final String ACTIVATION = "enable";
    static QualifiedName activationKey = new QualifiedName("org.eclipse.cdt.core.indexmodel", "enable");

    public boolean isEnabled(IProject project) {
        String prop = null;
        try {
            if (project != null) {
                prop = project.getPersistentProperty(activationKey);
            }
        }
        catch (CoreException coreException) {}
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public void setEnabled(IProject project, boolean on) {
        try {
            if (project != null) {
                Boolean newValue = new Boolean(on);
                Boolean oldValue = new Boolean(this.isEnabled(project));
                if (!oldValue.equals(newValue)) {
                    project.setPersistentProperty(activationKey, newValue.toString());
                    if (on) {
                        this.addResource((IResource)project);
                    } else {
                        this.removeResource((IResource)project);
                    }
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public ITagEntry[] query(IProject project, String tag) {
        return manager.query(project, tag, true, false);
    }

    public ITagEntry[] query(IProject project, String tag, boolean ignoreCase, boolean exactMatch) {
        return manager.query(project, tag, ignoreCase, exactMatch);
    }

    public void addResource(IResource resource) {
        manager.addResource(resource);
    }

    public void removeResource(IResource resource) {
        manager.removeResource(resource);
    }

    public void addAll() {
        manager.addAll();
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    public static IndexModel getDefault() {
        if (indexModel == null) {
            indexModel = new IndexModel();
            manager = IndexManager.getDefault();
        }
        return indexModel;
    }

    private IndexModel() {
    }
}

