/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import org.eclipse.cdt.core.build.managed.BuildException;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.IOptionCategory;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionReference
implements IOption {
    private IOption option;
    private ToolReference owner;
    private Object value;

    public OptionReference(ToolReference owner, IOption option) {
        this.owner = owner;
        this.option = option;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, IConfigurationElement element) {
        this.owner = owner;
        this.option = owner.getTool().getOption(element.getAttribute("id"));
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, Element element) {
        this.owner = owner;
        this.option = owner.getTool().getOption(element.getAttribute("id"));
        owner.addOptionReference(this);
    }

    public void serealize(Document doc, Element element) {
        element.setAttribute("id", this.option.getId());
        this.option = this.owner.getOption(element.getAttribute("id"));
    }

    public String[] getApplicableValues() {
        return this.option.getApplicableValues();
    }

    public IOptionCategory getCategory() {
        return this.option.getCategory();
    }

    public String getName() {
        return this.option.getName();
    }

    public String[] getStringListValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringListValue();
        }
        if (this.getValueType() == 1) {
            return (String[])this.value;
        }
        throw new BuildException("bad value type");
    }

    public String getStringValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringValue();
        }
        if (this.getValueType() == 0) {
            return (String)this.value;
        }
        throw new BuildException("bad value type");
    }

    public ITool getTool() {
        return this.owner;
    }

    public ToolReference getToolReference() {
        return this.owner;
    }

    public int getValueType() {
        return this.option.getValueType();
    }

    public String getId() {
        return this.option.getId();
    }

    public boolean references(IOption target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.option instanceof OptionReference) {
            return ((OptionReference)this.option).references(target);
        }
        return this.option.equals(target);
    }

    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException("bad value type");
        }
        this.value = value;
    }

    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() != 1) {
            throw new BuildException("bad value type");
        }
        this.value = value;
    }
}

