/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.build.managed.Target;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceBuildInfo {
    private IResource owner;
    private Map targetMap = new HashMap();
    private List targets = new ArrayList();

    public ResourceBuildInfo() {
    }

    public ResourceBuildInfo(IResource owner, Element element) {
        this();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("target")) {
                new Target(this, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public IResource getOwner() {
        return this.owner;
    }

    public Target getTarget(String id) {
        return (Target)this.targetMap.get(id);
    }

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(Target target) {
        this.targetMap.put(target.getId(), target);
        this.targets.add(target);
    }

    public void serialize(Document doc, Element element) {
        int i = 0;
        while (i < this.targets.size()) {
            Element targetElement = doc.createElement("target");
            element.appendChild(targetElement);
            ((Target)this.targets.get(i)).serialize(doc, targetElement);
            ++i;
        }
    }
}

