/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.IOptionCategory;
import org.eclipse.cdt.core.build.managed.ITarget;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.Configuration;
import org.eclipse.cdt.internal.core.build.managed.OptionReference;
import org.eclipse.cdt.internal.core.build.managed.Target;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolReference
implements ITool {
    private ITool parent;
    private IConfiguration owner;
    private List optionReferences;
    private Map optionRefMap;

    public ToolReference(Configuration owner, ITool parent) {
        this.owner = owner;
        this.parent = parent;
        owner.addToolReference(this);
    }

    public ToolReference(Configuration owner, IConfigurationElement element) {
        this.owner = owner;
        this.parent = ((Target)owner.getTarget()).getTool(element.getAttribute("id"));
        owner.addToolReference(this);
        IConfigurationElement[] toolElements = element.getChildren();
        int m = 0;
        while (m < toolElements.length) {
            IConfigurationElement toolElement = toolElements[m];
            if (toolElement.getName().equals("optionRef")) {
                new OptionReference(this, toolElement);
            }
            ++m;
        }
    }

    public ToolReference(Configuration owner, Element element) {
    }

    public void serealize(Document doc, Element element) {
        element.setAttribute("id", this.parent.getId());
        if (this.optionReferences != null) {
            int i = 0;
            while (i < this.optionReferences.size()) {
                OptionReference optionRef = (OptionReference)this.optionReferences.get(i);
                Element optionRefElement = doc.createElement("optionRef");
                optionRef.serealize(doc, optionRefElement);
                ++i;
            }
        }
    }

    public IConfiguration getConfiguration() {
        return this.owner;
    }

    public ITool getTool() {
        return this.parent;
    }

    public IOption createOption() {
        return null;
    }

    public IOption[] getOptions() {
        IOption[] options = this.parent.getOptions();
        int i = 0;
        while (i < options.length) {
            OptionReference ref = this.getOptionReference(options[i]);
            if (ref != null) {
                options[i] = ref;
            }
            ++i;
        }
        return options;
    }

    public ITarget getTarget() {
        return this.owner.getTarget();
    }

    public IOptionCategory getTopOptionCategory() {
        return this.parent.getTopOptionCategory();
    }

    public String getId() {
        return this.parent.getId();
    }

    public String getName() {
        return this.parent.getName();
    }

    public void setId(String id) {
    }

    public void setName(String name) {
    }

    public boolean references(ITool target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.parent instanceof ToolReference) {
            return ((ToolReference)this.parent).references(target);
        }
        return this.parent.equals(target);
    }

    private OptionReference getOptionReference(IOption option) {
        if (this.optionReferences != null) {
            int i = 0;
            while (i < this.optionReferences.size()) {
                OptionReference optionRef = (OptionReference)this.optionReferences.get(i);
                if (optionRef.references(option)) {
                    return optionRef;
                }
                ++i;
            }
        }
        return null;
    }

    public OptionReference createOptionReference(IOption option) {
        return new OptionReference(this, option);
    }

    public void addOptionReference(OptionReference optionRef) {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList();
        }
        this.optionReferences.add(optionRef);
    }

    public IOption getOption(String id) {
        return null;
    }
}

