/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BinaryFunction;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.BinaryModule;
import org.eclipse.cdt.internal.core.model.BinaryVariable;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class Binary
extends Openable
implements IBinary {
    IBinaryParser.IBinaryFile binaryFile;

    public Binary(ICElement parent, IFile file, IBinaryParser.IBinaryFile bin) {
        super(parent, (IResource)file, 14);
        this.binaryFile = bin;
    }

    public Binary(ICElement parent, IPath path, IBinaryParser.IBinaryFile bin) {
        super(parent, path, 14);
        this.binaryFile = bin;
    }

    public boolean isSharedLib() {
        if (this.binaryFile != null) {
            return this.binaryFile.getType() == 4;
        }
        return false;
    }

    public boolean isExecutable() {
        if (this.binaryFile != null) {
            return this.binaryFile.getType() == 2;
        }
        return false;
    }

    public boolean isObject() {
        if (this.binaryFile != null) {
            return this.binaryFile.getType() == 1;
        }
        return false;
    }

    public boolean isCore() {
        if (this.binaryFile != null) {
            return this.binaryFile.getType() == 16;
        }
        return false;
    }

    public boolean hasDebug() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).hasDebug();
        }
        return false;
    }

    public String getCPU() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).getCPU();
        }
        return "";
    }

    public String[] getNeededSharedLibs() {
        if (this.isExecutable() || this.isSharedLib()) {
            return ((IBinaryParser.IBinaryExecutable)this.binaryFile).getNeededSharedLibs();
        }
        return new String[0];
    }

    public long getText() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).getText();
        }
        return 0L;
    }

    public long getData() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).getData();
        }
        return 0L;
    }

    public long getBSS() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).getBSS();
        }
        return 0L;
    }

    public String getSoname() {
        if (this.isSharedLib()) {
            return ((IBinaryParser.IBinaryShared)this.binaryFile).getSoName();
        }
        return "";
    }

    public boolean isLittleEndian() {
        if (this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) {
            return ((IBinaryParser.IBinaryObject)this.binaryFile).isLittleEndian();
        }
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().putInfo(this, info);
        return this.computeChildren(info, underlyingResource);
    }

    boolean computeChildren(OpenableInfo info, IResource res) {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            HashMap hash = new HashMap();
            IBinaryParser.ISymbol[] symbols = ((IBinaryParser.IBinaryObject)this.binaryFile).getSymbols();
            int i = 0;
            while (i < symbols.length) {
                switch (symbols[i].getType()) {
                    case 1: {
                        this.addFunction(info, symbols[i], hash);
                        break;
                    }
                    case 2: {
                        this.addVariable(info, symbols[i], hash);
                    }
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private void addFunction(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        String filename = symbol.getFilename();
        BinaryFunction function = null;
        if (filename != null && !filename.equals("??")) {
            BinaryModule module = null;
            Path path = new Path(filename);
            if (hash.containsKey(path)) {
                module = (BinaryModule)hash.get(path);
            } else {
                module = new BinaryModule(this, (IPath)path);
                hash.put(path, module);
                info.addChild(module);
            }
            function = new BinaryFunction((ICElement)module, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(function);
        } else {
            function = new BinaryFunction((ICElement)this, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(function);
        }
    }

    private void addVariable(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        String filename = symbol.getFilename();
        BinaryVariable variable = null;
        if (filename != null && !filename.equals("??")) {
            BinaryModule module = null;
            Path path = new Path(filename);
            if (hash.containsKey(path)) {
                module = (BinaryModule)hash.get(path);
            } else {
                module = new BinaryModule(this, (IPath)path);
                hash.put(path, module);
                info.addChild(module);
            }
            variable = new BinaryVariable((ICElement)module, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(variable);
        } else {
            variable = new BinaryVariable((ICElement)this, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(variable);
        }
    }
}

