/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.Symbol;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class ElfBinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile,
IBinaryParser.IBinaryObject,
IBinaryParser.IBinaryExecutable,
IBinaryParser.IBinaryShared {
    IPath path;
    AR.ARHeader header;
    long timestamp;
    String soname;
    String[] needed;
    ElfHelper.Sizes sizes;
    Elf.Attribute attribute;
    ArrayList symbols;

    public ElfBinaryFile(IPath p) throws IOException {
        this(p, null);
    }

    public ElfBinaryFile(IPath p, AR.ARHeader h) throws IOException {
        this.header = h;
        this.path = p;
        this.loadInformation();
        this.hasChanged();
    }

    public IPath getPath() {
        return this.path;
    }

    public long getBSS() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.bss;
        }
        return 0L;
    }

    public String getCPU() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.data;
        }
        return 0L;
    }

    public long getText() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.text;
        }
        return 0L;
    }

    public String getSoName() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        if (this.soname != null) {
            return this.soname;
        }
        return "";
    }

    public boolean hasDebug() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.isLittleEndian();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        if (this.needed != null) {
            return this.needed;
        }
        return new String[0];
    }

    public int getType() {
        int type = 0;
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            switch (this.attribute.getType()) {
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 4;
                    break;
                }
                case 3: {
                    type = 1;
                    break;
                }
                case 4: {
                    type = 16;
                }
            }
        }
        return type;
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            if (this.symbols == null) {
                this.symbols = new ArrayList(5);
            }
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.symbols.toArray(new IBinaryParser.ISymbol[0]);
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.header != null) {
            try {
                stream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        } else if (this.path != null) {
            try {
                stream = new FileInputStream(this.path.toFile());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        if (this.path != null) {
            return this.path.lastSegment().toString();
        }
        return "";
    }

    public String toString() {
        return this.getName();
    }

    protected Elf.Attribute getAttribute() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.attribute;
    }

    protected ElfHelper.Sizes getSizes() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.sizes;
    }

    boolean hasChanged() {
        long modification = this.path.toFile().lastModified();
        boolean changed = modification != this.timestamp;
        this.timestamp = modification;
        return changed;
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.header != null) {
            return new ElfHelper(this.header.getElf());
        }
        if (this.path != null) {
            return new ElfHelper(this.path.toOSString());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void loadInformation() throws IOException {
        ElfHelper helper = this.getElfHelper();
        this.loadInformation(helper);
        helper.dispose();
    }

    private void loadInformation(ElfHelper helper) throws IOException {
        this.loadAttributes(helper);
        if (this.symbols != null) {
            this.symbols.clear();
            this.loadSymbols(helper);
            this.symbols.trimToSize();
        }
    }

    private void loadAttributes(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
    }

    private void loadSymbols(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
        this.addSymbols(helper.getExternalFunctions(), 1);
        this.addSymbols(helper.getLocalFunctions(), 1);
        this.addSymbols(helper.getExternalObjects(), 2);
        this.addSymbols(helper.getLocalObjects(), 2);
        this.symbols.trimToSize();
    }

    private void addSymbols(Elf.Symbol[] array, int type) {
        int i = 0;
        while (i < array.length) {
            Symbol sym = new Symbol();
            sym.type = type;
            sym.name = array[i].toString();
            sym.addr = array[i].st_value;
            try {
                if (this.header == null) {
                    sym.filename = array[i].getFilename();
                    sym.endLine = sym.startLine = array[i].getFuncLineNumber();
                }
            }
            catch (IOException iOException) {}
            this.symbols.add(sym);
            ++i;
        }
    }
}

