/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.OffsetToLineMapping;
import org.eclipse.cdt.internal.core.parser.ScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerException;

public class ContextStack {
    private IScannerContext currentContext;
    private IScannerContext topContext;
    private Stack contextStack = new Stack();
    private LinkedList undoStack = new LinkedList();
    private Set inclusions = new HashSet();
    private Set defines = new HashSet();
    private OffsetToLineMapping offsetLineMap = new OffsetToLineMapping();

    public void updateContext(Reader reader, String filename, int type) throws ScannerException {
        this.undoStack.clear();
        this.push(new ScannerContext().initialize(reader, filename, type));
    }

    protected void push(IScannerContext context) throws ScannerException {
        if (context.getKind() == 2) {
            if (!this.inclusions.add(context.getFilename())) {
                throw new ScannerException("Inclusion " + context.getFilename() + " already encountered.");
            }
        } else if (context.getKind() == 3 && !this.defines.add(context.getFilename())) {
            throw new ScannerException("Define " + context.getFilename() + " already encountered.");
        }
        if (this.currentContext != null) {
            this.contextStack.push(this.currentContext);
        }
        this.currentContext = context;
        if (context.getKind() == 1) {
            this.topContext = context;
        }
    }

    public boolean rollbackContext() {
        try {
            this.currentContext.getReader().close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing reader");
        }
        if (this.currentContext.getKind() == 2) {
            this.inclusions.remove(this.currentContext.getFilename());
        } else if (this.currentContext.getKind() == 3) {
            this.defines.remove(this.currentContext.getFilename());
        }
        this.undoStack.addFirst(this.currentContext);
        if (this.contextStack.isEmpty()) {
            this.currentContext = null;
            return false;
        }
        this.currentContext = (ScannerContext)this.contextStack.pop();
        return true;
    }

    public void undoRollback(IScannerContext undoTo) throws ScannerException {
        if (this.currentContext == undoTo) {
            return;
        }
        int size = this.undoStack.size();
        if (size > 0) {
            this.undoStack.iterator();
            int i = size;
            while (i > 0) {
                this.push((IScannerContext)this.undoStack.removeFirst());
                if (this.currentContext == undoTo) break;
                --i;
            }
        }
    }

    protected boolean shouldExpandDefinition(String symbol) {
        return !this.defines.contains(symbol);
    }

    public IScannerContext getCurrentContext() {
        return this.currentContext;
    }

    public IScannerContext getTopContext() {
        return this.topContext;
    }

    public int mapOffsetToLineNumber(int offset) {
        return this.offsetLineMap.getLineNo(offset);
    }

    public void newLine() {
        if (this.currentContext == this.topContext) {
            this.offsetLineMap.newLine(this.topContext.getOffset());
        }
    }

    public void recantNewline() {
        if (this.currentContext == this.topContext) {
            this.offsetLineMap.recantLastNewLine();
        }
    }
}

