/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.TypeInfo;

public class Declaration
implements Cloneable {
    private String _name;
    private Object _object;
    private boolean _needsDefinition;
    private int _cvQualifier;
    protected TypeInfo _typeInfo;
    protected Declaration _containingScope;
    protected LinkedList _parentScopes;
    protected LinkedList _usingDirectives;
    protected HashMap _containedDeclarations;
    protected LinkedList _parameters;
    protected int _returnType;
    protected int _depth;

    public Declaration() {
        this._typeInfo = new TypeInfo();
    }

    public Declaration(String name) {
        this._name = name;
        this._typeInfo = new TypeInfo();
    }

    public Declaration(String name, Object obj) {
        this._name = name;
        this._object = obj;
        this._typeInfo = new TypeInfo();
    }

    public Object clone() {
        Declaration copy = null;
        try {
            copy = (Declaration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        copy._object = null;
        copy._parentScopes = this._parentScopes != null ? (LinkedList)this._parentScopes.clone() : null;
        copy._usingDirectives = this._usingDirectives != null ? (LinkedList)this._usingDirectives.clone() : null;
        copy._containedDeclarations = this._containedDeclarations != null ? (HashMap)this._containedDeclarations.clone() : null;
        copy._parameters = this._parameters != null ? (LinkedList)this._parameters.clone() : null;
        return copy;
    }

    public void setType(int t) throws ParserSymbolTableException {
        this._typeInfo.setType(t);
    }

    public int getType() {
        return this._typeInfo.getType();
    }

    public boolean isType(int type) {
        return this._typeInfo.isType(type, 0);
    }

    public boolean isType(int type, int upperType) {
        return this._typeInfo.isType(type, upperType);
    }

    public Declaration getTypeDeclaration() {
        return this._typeInfo.getTypeDeclaration();
    }

    public void setTypeDeclaration(Declaration type) {
        this._typeInfo.setTypeDeclaration(type);
    }

    public TypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object obj) {
        this._object = obj;
    }

    public Declaration getContainingScope() {
        return this._containingScope;
    }

    protected void setContainingScope(Declaration scope) {
        this._containingScope = scope;
        this._depth = scope._depth + 1;
    }

    public void addParent(Declaration parent) {
        this.addParent(parent, false);
    }

    public void addParent(Declaration parent, boolean virtual) {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        this._parentScopes.add(new ParentWrapper(parent, virtual));
    }

    public Map getContainedDeclarations() {
        return this._containedDeclarations;
    }

    public Map createContained() {
        if (this._containedDeclarations == null) {
            this._containedDeclarations = new HashMap();
        }
        return this._containedDeclarations;
    }

    public LinkedList getParentScopes() {
        return this._parentScopes;
    }

    public boolean needsDefinition() {
        return this._needsDefinition;
    }

    public void setNeedsDefinition(boolean need) {
        this._needsDefinition = need;
    }

    public int getCVQualifier() {
        return this._cvQualifier;
    }

    public void setCVQualifier(int cv) {
        this._cvQualifier = cv;
    }

    public String getPtrOperator() {
        return this._typeInfo.getPtrOperator();
    }

    public void setPtrOperator(String ptrOp) {
        this._typeInfo.setPtrOperator(ptrOp);
    }

    public int getReturnType() {
        return this._returnType;
    }

    public void setReturnType(int type) {
        this._returnType = type;
    }

    public void addParameter(Declaration typeDecl, int cvQual, String ptrOperator, boolean hasDefault) {
        if (this._parameters == null) {
            this._parameters = new LinkedList();
        }
        TypeInfo info = new TypeInfo(1, typeDecl, cvQual, ptrOperator, hasDefault);
        this._parameters.add(info);
    }

    public void addParameter(int type, int cvQual, String ptrOperator, boolean hasDefault) {
        if (this._parameters == null) {
            this._parameters = new LinkedList();
        }
        TypeInfo info = new TypeInfo(type, null, cvQual, ptrOperator, hasDefault);
        this._parameters.add(info);
    }

    public boolean hasSameParameters(Declaration function) {
        if (function.getType() != this.getType()) {
            return false;
        }
        int size = this._parameters.size();
        if (function._parameters.size() != size) {
            return false;
        }
        Iterator iter = this._parameters.iterator();
        Iterator fIter = function._parameters.iterator();
        TypeInfo info = null;
        TypeInfo fInfo = null;
        int i = size;
        while (i > 0) {
            info = (TypeInfo)iter.next();
            if (!info.equals(fInfo = (TypeInfo)fIter.next())) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected class ParentWrapper {
        public boolean isVirtual = false;
        public Declaration parent = null;

        public ParentWrapper(Declaration p, boolean v) {
            this.parent = p;
            this.isVirtual = v;
        }
    }
}

