/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.OutputStream;

public class PTYOutputStream
extends OutputStream {
    private int fd;

    static {
        System.loadLibrary("pty");
    }

    public PTYOutputStream(int fd) {
        this.fd = fd;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, off, len);
        this.write0(this.fd, tmpBuf, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        if (this.fd == -1) {
            return;
        }
        int status = this.close0(this.fd);
        if (status == -1) {
            throw new IOException("close error");
        }
        this.fd = -1;
    }

    private native int write0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;
}

