/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DebugTextHover
implements ITextHover {
    static /* synthetic */ Class class$0;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            return null;
        }
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (launchManager == null) {
            return null;
        }
        IDebugTarget[] targets = launchManager.getDebugTargets();
        if (targets != null && targets.length > 0) {
            try {
                IDocument document = textViewer.getDocument();
                if (document == null) {
                    return null;
                }
                String expression = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                if (expression == null) {
                    return null;
                }
                if ((expression = expression.trim()).length() == 0) {
                    return null;
                }
                ArrayList<IDebugTarget> targetList = new ArrayList<IDebugTarget>(targets.length);
                int i = 0;
                while (i < targets.length) {
                    ICExpressionEvaluator ee;
                    IDebugTarget iDebugTarget = targets[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ee = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz)) != null) {
                        targetList.add(targets[i]);
                    }
                    ++i;
                }
                StringBuffer buffer = new StringBuffer();
                boolean showDebugTarget = targetList.size() > 1;
                Iterator iterator = targetList.iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    ICExpressionEvaluator ee;
                    IDebugTarget target = (IDebugTarget)iterator.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!(ee = (ICExpressionEvaluator)target.getAdapter((Class)clazz)).canEvaluate()) continue;
                    String result = this.evaluateExpression(ee, expression);
                    try {
                        if (result == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            buffer.append('\n');
                        }
                        if (showDebugTarget) {
                            buffer.append('[');
                            buffer.append(target.getName());
                            buffer.append("]: ");
                        }
                        buffer.append(expression);
                        buffer.append('=');
                        buffer.append(result);
                    }
                    catch (DebugException x) {
                        CDebugUIPlugin.log(x);
                    }
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        if (viewer != null) {
            return CDebugUIUtils.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    private String evaluateExpression(ICExpressionEvaluator ee, String expression) {
        String result = null;
        try {
            result = ee.evaluateExpressionToString(expression);
        }
        catch (DebugException debugException) {}
        return result;
    }
}

