/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class RegistersViewer
extends TreeViewer {
    private Item fNewItem;

    public RegistersViewer(Composite parent) {
        super(parent);
    }

    public RegistersViewer(Composite parent, int style) {
        super(parent, style);
    }

    public RegistersViewer(Tree tree) {
        super(tree);
    }

    public void refresh() {
        this.getControl().setRedraw(false);
        super.refresh();
        Item[] children = this.getChildren((Widget)this.getControl());
        if (children != null) {
            Color c = CDebugUIPlugin.getPreferenceColor("Changed.Register.RGB");
            int i = 0;
            while (i < children.length) {
                this.updateColor((TreeItem)children[i], c);
                ++i;
            }
        }
        this.getControl().setRedraw(true);
        if (this.getSelection().isEmpty() && this.getNewItem() != null) {
            if (!this.getNewItem().isDisposed()) {
                this.showItem(this.getNewItem());
            }
            this.setNewItem(null);
        }
    }

    protected void updateColor(TreeItem item, Color c) {
        if (item.getData() instanceof IVariable) {
            IVariable var = (IVariable)item.getData();
            try {
                if (var.hasValueChanged()) {
                    item.setForeground(c);
                } else {
                    item.setForeground(null);
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log((Throwable)e);
            }
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            this.updateColor(children[i], c);
            ++i;
        }
    }

    protected Item newItem(Widget parent, int style, int index) {
        if (index != -1) {
            this.setNewItem(super.newItem(parent, style, index));
            return this.getNewItem();
        }
        return super.newItem(parent, style, index);
    }

    protected Item getNewItem() {
        return this.fNewItem;
    }

    protected void setNewItem(Item newItem) {
        this.fNewItem = newItem;
    }
}

