/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

public class SourcePropertyPage
extends PropertyPage {
    private SourceLookupBlock fBlock = null;
    private boolean fHasActiveContents = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourcePropertyPage() {
        this.noDefaultAndApplyButton();
        this.fBlock = new SourceLookupBlock();
    }

    protected Control createContents(Composite parent) {
        ICDebugTarget target = this.getDebugTarget();
        if (target == null || target.isTerminated() || target.isDisconnected()) {
            return this.createTerminatedContents(parent);
        }
        this.fHasActiveContents = true;
        return this.createActiveContents(parent);
    }

    protected Control createTerminatedContents(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("Terminated.");
        return label;
    }

    protected Control createActiveContents(Composite parent) {
        this.fBlock.setProject(this.getProject());
        this.fBlock.initialize(this.getSourceLocator());
        this.fBlock.createControl(parent);
        return this.fBlock.getControl();
    }

    protected ICDebugTarget getDebugTarget() {
        IAdaptable element = this.getElement();
        if (element != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICDebugTarget)element.getAdapter((Class)clazz);
        }
        return null;
    }

    private ICSourceLocator getSourceLocator() {
        ICDebugTarget target = this.getDebugTarget();
        if (target != null && target.getLaunch().getSourceLocator() instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)target.getLaunch().getSourceLocator();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean performOk() {
        if (this.fBlock.isDirty()) {
            try {
                this.setSourceLocations(this.fBlock.getSourceLocations());
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private void setSourceLocations(ICSourceLocation[] locations) throws DebugException {
        ICDebugTarget target = this.getDebugTarget();
        if (target != null && target.getLaunch().getSourceLocator() instanceof IAdaptable) {
            ICSourceLocator locator;
            IAdaptable iAdaptable = (IAdaptable)target.getLaunch().getSourceLocator();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((locator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null) {
                locator.setSourceLocations(locations);
                if (target.getLaunch().getSourceLocator() instanceof IPersistableSourceLocator) {
                    ILaunchConfiguration configuration = target.getLaunch().getLaunchConfiguration();
                    this.saveChanges(configuration, (IPersistableSourceLocator)target.getLaunch().getSourceLocator());
                }
            }
        }
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), null);
        }
    }

    private IProject getProject() {
        IProject project = null;
        ICDebugTarget target = this.getDebugTarget();
        if (target != null) {
            ILaunchConfiguration configuration = target.getLaunch().getLaunchConfiguration();
            try {
                String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                if (projectName != null && projectName.length() > 0) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                }
            }
            catch (CoreException coreException) {}
        }
        return project;
    }
}

