/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.internal.ui.WorkingDirectoryBlock;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CArgumentsTab
extends CLaunchConfigurationTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = new WorkingDirectoryBlock();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.fPrgmArgumentsLabel = new Label(comp, 0);
        this.fPrgmArgumentsLabel.setText("C/C++ Program Arguments:");
        this.fPrgmArgumentsText = new Text(comp, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        config.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading configuration " + e.getStatus().getMessage());
            LaunchUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return "Arguments";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ARGUMENTS_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

