/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.editors.NoSymbolOrSourceElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

public class CUISourceLocator
implements IAdaptable {
    private IProject fProject = null;
    private CSourceManager fSourceLocator;
    protected boolean fAllowedToAsk;
    protected boolean fNewLocationAttached;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CUISourceLocator(IProject project) {
        this.fProject = project;
        this.fSourceLocator = new CSourceManager((ISourceLocator)new CSourceLocator(project));
        this.fAllowedToAsk = true;
        this.fNewLocationAttached = false;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object res = this.fSourceLocator.getSourceElement(stackFrame);
        if (res == null && this.fAllowedToAsk) {
            IStackFrameInfo frameInfo;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            res = (frameInfo = (IStackFrameInfo)stackFrame.getAdapter((Class)clazz)) != null && frameInfo.getFile() != null && frameInfo.getFile().length() > 0 ? new FileNotFoundElement(stackFrame) : new NoSymbolOrSourceElement(stackFrame);
        }
        return res;
    }

    protected void attachSourceLocation(ILaunch launch, String fileName) {
        Path path = new Path(fileName);
        Wizard wizard = null;
        if (path.isAbsolute()) {
            path = path.removeLastSegments(1);
            wizard = new AddDirectorySourceLocationWizard((IPath)path);
        } else {
            wizard = new AddSourceLocationWizard(this.fSourceLocator.getSourceLocations());
        }
        WizardDialog dialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fSourceLocator.addSourceLocation(wizard.getSourceLocation());
            if (launch.getSourceLocator() instanceof IPersistableSourceLocator) {
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                this.saveChanges(configuration, (IPersistableSourceLocator)launch.getSourceLocator());
            }
            this.fNewLocationAttached = true;
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.fSourceLocator != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz)) {
                return this.fSourceLocator;
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return this.fSourceLocator;
            }
        }
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), null);
        }
    }
}

