/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.List;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SourceLookupBlock {
    private static final String CP_LOCATION = "location";
    private static final String CP_ASSOCIATION = "association";
    private Composite fControl = null;
    private Shell fShell = null;
    private SourceListDialogField fSourceListField;
    private ILaunchConfigurationDialog fLaunchConfigurationDialog = null;
    private boolean fIsDirty = false;
    private ICSourceLocator fLocator = null;
    private IProject fProject = null;

    public SourceLookupBlock() {
        String[] buttonLabels = new String[]{"Add...", null, "Up", "Down", null, "Remove", null, "Restore Defaults"};
        SourceLookupAdapter adapter = new SourceLookupAdapter();
        this.fSourceListField = new SourceListDialogField(adapter, buttonLabels, (ILabelProvider)new SourceLookupLabelProvider());
        this.fSourceListField.setLabelText("Source Locations");
        this.fSourceListField.setUpButtonIndex(2);
        this.fSourceListField.setDownButtonIndex(3);
        this.fSourceListField.setRemoveButtonIndex(5);
    }

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fControl.setLayout((Layout)layout);
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)this.fControl);
        this.fSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fSourceListField.getListControl(null));
        TableViewer viewer = this.fSourceListField.getTableViewer();
        Table table = viewer.getTable();
        TextCellEditor cellEditor = new TextCellEditor((Composite)table);
        viewer.setCellEditors(new CellEditor[]{null, cellEditor});
        viewer.setColumnProperties(new String[]{CP_LOCATION, CP_ASSOCIATION});
        viewer.setCellModifier(this.createCellModifier());
    }

    private ICellModifier createCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION)) {
                    return ((CDirectorySourceLocation)element).getAssociation() != null ? ((CDirectorySourceLocation)element).getAssociation().toOSString() : "";
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Path association;
                Object entry = SourceLookupBlock.this.getSelection();
                if (entry instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION) && value instanceof String && (association = new Path((String)value)).isValidPath((String)value)) {
                    ((CDirectorySourceLocation)entry).setAssociation((IPath)association);
                    SourceLookupBlock.this.getSourceListField().refresh();
                    SourceLookupBlock.this.updateLaunchConfigurationDialog();
                }
            }
        };
    }

    public Control getControl() {
        return this.fControl;
    }

    public void initialize(ICSourceLocator locator) {
        this.fLocator = locator;
        ICSourceLocation[] locations = new ICSourceLocation[]{};
        if (this.fLocator != null) {
            locations = this.fLocator.getSourceLocations();
        }
        this.resetLocations(locations);
    }

    private void resetLocations(ICSourceLocation[] locations) {
        this.fSourceListField.removeAllElements();
        int i = 0;
        while (i < locations.length) {
            this.fSourceListField.addElement(locations[i]);
            ++i;
        }
    }

    protected void doButtonPressed(int index) {
        switch (index) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.fIsDirty = true;
                break;
            }
            case 7: {
                this.restoreDefaults();
            }
            case 2: 
            case 3: 
            case 5: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void doSelectionChanged() {
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceListField.getElements().toArray(new ICSourceLocation[this.fSourceListField.getElements().size()]);
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard wizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog dialog = new WizardDialog(this.fControl.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fSourceListField.addElement(wizard.getSourceLocation());
            return true;
        }
        return false;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateMessage();
            this.getLaunchConfigurationDialog().updateButtons();
            this.fIsDirty = false;
        }
    }

    public ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog launchConfigurationDialog) {
        this.fLaunchConfigurationDialog = launchConfigurationDialog;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    protected Object getSelection() {
        List list = this.fSourceListField.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    protected void restoreDefaults() {
        ICSourceLocation[] locations = new ICSourceLocation[]{};
        if (this.getProject() != null) {
            locations = CSourceLocator.getDefaultSourceLocations((IProject)this.getProject());
        }
        this.resetLocations(locations);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public SourceListDialogField getSourceListField() {
        return this.fSourceListField;
    }

    private class SourceListDialogField
    extends ListDialogField {
        public SourceListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean managedButtonPressed(int index) {
            super.managedButtonPressed(index);
            return false;
        }

        protected TableViewer createTableViewer(Composite parent) {
            TableViewer viewer = super.createTableViewer(parent);
            Table table = viewer.getTable();
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            GridData gd = new GridData(272);
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            table.setLayoutData((Object)gd);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            TableColumn[] columns = table.getColumns();
            columns[0].setText("Location");
            columns[1].setText("Association");
            return viewer;
        }
    }

    private class SourceLookupAdapter
    implements IListAdapter {
        SourceLookupAdapter() {
        }

        public void customButtonPressed(DialogField field, int index) {
            SourceLookupBlock.this.doButtonPressed(index);
        }

        public void selectionChanged(DialogField field) {
            SourceLookupBlock.this.doSelectionChanged();
        }
    }

    private static class SourceLookupLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SourceLookupLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IProjectSourceLocation) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.project_obj.gif");
                }
                if (element instanceof IDirectorySourceLocation) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.folder_obj.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IProjectSourceLocation) {
                    return ((IProjectSourceLocation)element).getProject().getName();
                }
                if (element instanceof IDirectorySourceLocation) {
                    return ((IDirectorySourceLocation)element).getDirectory().toOSString();
                }
            } else if (columnIndex == 1 && element instanceof IDirectorySourceLocation && ((IDirectorySourceLocation)element).getAssociation() != null) {
                return ((IDirectorySourceLocation)element).getAssociation().toOSString();
            }
            return "";
        }
    }
}

