/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class CArrayPartitionValue
extends CDebugElement
implements ICValue {
    private List fCDIVariables;
    private List fVariables = Collections.EMPTY_LIST;
    private int fStart;
    private int fEnd;

    public CArrayPartitionValue(CDebugTarget target, List cdiVariables, int start, int end) {
        super(target);
        this.fCDIVariables = cdiVariables;
        this.fStart = start;
        this.fEnd = end;
    }

    public int getType() {
        return 0;
    }

    public ICDIValue getUnderlyingValue() {
        return null;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public String getValueString() throws DebugException {
        return null;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fVariables.isEmpty()) {
            this.fVariables = new ArrayList(this.getEnd() - this.getStart() + 1);
            int i = this.getStart();
            while (i <= this.getEnd()) {
                this.fVariables.add(new CModificationVariable(this, (ICDIVariable)this.fCDIVariables.get(i - this.getStart())));
                ++i;
            }
        }
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }

    public void setChanged(boolean changed) throws DebugException {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).setChanged(changed);
        }
    }
}

