/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CValue;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;

public abstract class CVariable
extends CDebugElement
implements ICVariable,
ICDIEventListener,
ICastToType,
ICastToArray {
    private CDebugElement fParent;
    private ICDIVariable fCDIVariable;
    private ICDIVariable fShadow;
    protected ICValue fValue;
    private Boolean fEditable = null;
    private int fLastChangeIndex = -1;
    protected boolean fChanged = false;
    private String fTypeName = null;
    private int fFormat = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CVariable(CDebugTarget target) {
        super(target);
    }

    public CVariable(CDebugElement parent, ICDIVariable cdiVariable) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
        this.fCDIVariable = cdiVariable;
        this.fShadow = null;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            this.fValue = CValueFactory.createValue(this, this.getCurrentValue());
        }
        return this.fValue;
    }

    public boolean hasValueChanged() throws DebugException {
        if (this.isPointer()) {
            return false;
        }
        IValue value = this.getValue();
        if (value != null) {
            return value.hasVariables() ? false : this.fChanged;
        }
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public void setValue(IValue value) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICastToType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected final ICDIValue getCurrentValue() throws DebugException {
        try {
            return this.retrieveValue();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    protected void setChangeCount(int count) {
        this.fLastChangeIndex = count;
    }

    protected int getChangeCount() {
        return this.fLastChangeIndex;
    }

    protected ICDIValue getLastKnownValue() {
        if (this.fValue == null) {
            return null;
        }
        return this.fValue.getUnderlyingValue();
    }

    protected void dispose() {
        if (this.fValue != null) {
            ((CValue)this.fValue).dispose();
        }
        this.getCDISession().getEventManager().removeEventListener(this);
        try {
            if (this.getShadow() != null) {
                this.destroyShadow(this.getShadow());
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    protected synchronized void setChanged(boolean changed) throws DebugException {
        if (this.getValue() != null && this.getValue() instanceof ICValue) {
            ((ICValue)this.getValue()).setChanged(changed);
            if (!this.hasChildren()) {
                this.fChanged = changed;
            }
        }
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget()) && event instanceof ICDIChangedEvent && source instanceof ICDIVariable && source.equals(this.getCDIVariable())) {
            this.handleChangedEvent((ICDIChangedEvent)event);
        }
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        try {
            this.setChanged(true);
            this.getParent().fireChangeEvent(512);
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    protected CDebugElement getParent() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() {
        if (this.fShadow != null) {
            return this.fShadow;
        }
        return this.getOriginalCDIVariable();
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return this.getParent().getDebugTarget().isSuspended() && this.getCDIVariable() != null ? this.getCDIVariable().getValue() : this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        return this.getOriginalCDIVariable() != null ? this.getOriginalCDIVariable().getName() : null;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.fTypeName == null) {
            try {
                this.fTypeName = this.getCDIVariable().getTypeName();
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fTypeName;
    }

    protected void updateParentVariable(CValue parentValue) throws DebugException {
        parentValue.getParentVariable().setChanged(true);
        parentValue.getParentVariable().fireChangeEvent(256);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int format) throws DebugException {
        try {
            this.getCDIVariable().setFormat(format);
            this.fFormat = format;
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void refresh() throws DebugException {
        ((ICValue)this.getValue()).setChanged(true);
        this.fireChangeEvent(256);
    }

    public void cast(String type) throws DebugException {
        try {
            try {
                ICDIVariable newVar = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), type);
                ICDIVariable oldVar = this.getShadow();
                this.setShadow(newVar);
                if (oldVar != null) {
                    this.destroyShadow(oldVar);
                }
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (this.fValue != null) {
                ((CValue)this.fValue).dispose();
                this.fValue = null;
            }
            this.fEditable = null;
            this.fTypeName = null;
            this.fireChangeEvent(256);
            throw throwable;
        }
        Object var4_7 = null;
        if (this.fValue != null) {
            ((CValue)this.fValue).dispose();
            this.fValue = null;
        }
        this.fEditable = null;
        this.fTypeName = null;
        this.fireChangeEvent(256);
    }

    public String getCurrentType() {
        try {
            return this.getReferenceTypeName();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return "";
        }
    }

    public void restoreDefault() throws DebugException {
        ICDIVariable oldVar = this.getShadow();
        this.setShadow(null);
        if (oldVar != null) {
            this.destroyShadow(oldVar);
        }
        if (this.fValue != null) {
            ((CValue)this.fValue).dispose();
            this.fValue = null;
        }
        this.fEditable = null;
        this.fTypeName = null;
        this.fireChangeEvent(256);
    }

    public boolean supportsCasting() {
        CDebugTarget target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (target = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable();
    }

    protected ICDIVariable getOriginalCDIVariable() {
        return this.fCDIVariable;
    }

    private ICDIVariable getShadow() {
        return this.fShadow;
    }

    private void setShadow(ICDIVariable shadow) {
        this.fShadow = shadow;
    }

    private ICDIVariable createShadow(ICDIStackFrame cdiFrame, String type) throws DebugException {
        try {
            ICDIVariableObject varObject = this.getCDISession().getVariableManager().getVariableObjectAsType(this.getOriginalCDIVariable(), type);
            return this.getCDISession().getVariableManager().createVariable(varObject);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    private ICDIVariable createShadow(ICDIStackFrame cdiFrame, String type, int start, int length) throws DebugException {
        try {
            ICDIVariableObject varObject = this.getCDISession().getVariableManager().getVariableObjectAsArray(this.getOriginalCDIVariable(), type, start, length);
            return this.getCDISession().getVariableManager().createVariable(varObject);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    private void destroyShadow(ICDIVariable shadow) throws DebugException {
        try {
            this.getCDISession().getVariableManager().destroyVariable(shadow);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    public void castToArray(String type, int startIndex, int length) throws DebugException {
        try {
            try {
                ICDIVariable newVar = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), type, startIndex, length);
                ICDIVariable oldVar = this.getShadow();
                this.setShadow(newVar);
                if (oldVar != null) {
                    this.destroyShadow(oldVar);
                }
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (this.fValue != null) {
                ((CValue)this.fValue).dispose();
                this.fValue = null;
            }
            this.fEditable = null;
            this.fTypeName = null;
            this.fireChangeEvent(256);
            throw throwable;
        }
        Object var6_9 = null;
        if (this.fValue != null) {
            ((CValue)this.fValue).dispose();
            this.fValue = null;
        }
        this.fEditable = null;
        this.fTypeName = null;
        this.fireChangeEvent(256);
    }

    public boolean supportsCastToArray() {
        CDebugTarget target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (target = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable() && this.hasChildren();
    }

    public boolean hasChildren() {
        try {
            return this.getValue() != null && this.getValue().hasVariables();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean isEditable() {
        if (this.fEditable == null && this.getCDIVariable() != null) {
            try {
                this.fEditable = new Boolean(this.getCDIVariable().isEditable());
            }
            catch (CDIException e) {
                this.logError(e);
            }
        }
        return this.fEditable != null ? this.fEditable : false;
    }

    protected boolean isPointer() {
        return this.isEditable() && this.hasChildren();
    }
}

