/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CDirectorySourceLocation
implements IDirectorySourceLocation {
    private static final String ELEMENT_NAME = "cDirectorySourceLocation";
    private static final String ATTR_DIRECTORY = "directory";
    private static final String ATTR_ASSOCIATION = "association";
    private IPath fDirectory;
    private IPath fAssociation = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CDirectorySourceLocation() {
    }

    public CDirectorySourceLocation(IPath directory) {
        this.setDirectory(directory);
    }

    public CDirectorySourceLocation(IPath directory, IPath association) {
        this.setDirectory(directory);
        this.setAssociation(association);
    }

    public Object findSourceElement(String name) throws CoreException {
        if (this.getDirectory() != null) {
            File file = new File(name);
            if (file.isAbsolute()) {
                return this.findFileByAbsolutePath(name);
            }
            return this.findFileByRelativePath(name);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.core.runtime.IPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this.getDirectory();
        }
        return null;
    }

    private void setDirectory(IPath directory) {
        this.fDirectory = directory;
    }

    public IPath getDirectory() {
        return this.fDirectory;
    }

    public void getDirectory(IPath path) {
        this.fDirectory = path;
    }

    public void setAssociation(IPath association) {
        this.fAssociation = association;
    }

    public IPath getAssociation() {
        return this.fAssociation;
    }

    private Object findFileByAbsolutePath(String fileName) {
        Path filePath = new Path(fileName);
        IPath path = this.getDirectory();
        IPath association = this.getAssociation();
        if (path.isPrefixOf((IPath)filePath)) {
            filePath = path.append(filePath.removeFirstSegments(path.segmentCount()));
        } else if (association != null && association.isPrefixOf((IPath)filePath)) {
            filePath = path.append(filePath.removeFirstSegments(association.segmentCount()));
        } else {
            return null;
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (f != null && f.exists()) {
            return f;
        }
        File file = filePath.toFile();
        if (file.exists()) {
            return this.createExternalFileStorage((IPath)filePath);
        }
        return null;
    }

    private Object findFileByRelativePath(String fileName) {
        File file;
        IPath path = this.getDirectory();
        if (path != null && (file = (path = path.append(fileName)).toFile()).exists()) {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (f != null) {
                return f;
            }
            return this.createExternalFileStorage(path);
        }
        return null;
    }

    private IStorage createExternalFileStorage(IPath path) {
        return new FileStorage(path);
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement(ELEMENT_NAME);
        doc.appendChild(node);
        node.setAttribute(ATTR_DIRECTORY, this.getDirectory().toOSString());
        if (this.getAssociation() != null) {
            node.setAttribute(ATTR_ASSOCIATION, this.getAssociation().toOSString());
        }
        try {
            return CDebugUtils.serializeDocument((Document)doc, " ");
        }
        catch (IOException e) {
            this.abort(MessageFormat.format("Unable to create memento for C/C++ directory source location {0}", this.getDirectory().toOSString()), e);
            return null;
        }
    }

    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Path path;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String dir = root.getAttribute(ATTR_DIRECTORY);
            if (this.isEmpty(dir)) {
                this.abort("Unable to initialize source location - missing directory path", null);
            } else {
                path = new Path(dir);
                if (path.isValidPath(dir) && path.toFile().isDirectory()) {
                    this.setDirectory((IPath)path);
                } else {
                    this.abort(MessageFormat.format("Unable to initialize source location - invalid directory path {0}", dir), null);
                }
            }
            dir = root.getAttribute(ATTR_ASSOCIATION);
            if (this.isEmpty(dir)) {
                this.setAssociation(null);
            } else {
                path = new Path(dir);
                if (path.isValidPath(dir)) {
                    this.setAssociation((IPath)path);
                } else {
                    this.setAssociation(null);
                }
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source location.", ex);
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

