/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.DisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;

public class DisassemblyManager {
    private static final int DISASSEMBLY_MAX_LINE_COUNT = 100;
    private static final int DISASSEMBLY_BLOCK_SIZE = 100;
    private CDebugTarget fDebugTarget;
    private DisassemblyStorage fStorage = null;
    static /* synthetic */ Class class$0;

    public DisassemblyManager(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    public int getLineNumber(IStackFrame frame) {
        DisassemblyStorage storage;
        IStackFrameInfo info;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IStackFrameInfo)frame.getAdapter((Class)clazz)) != null && (storage = this.getSourceElement(info)) != null) {
            return storage.getLineNumber(info.getAddress());
        }
        return 0;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.getSourceElement((IStackFrameInfo)stackFrame.getAdapter((Class)clazz));
        }
        return null;
    }

    public Object getSourceElement(long address) {
        DisassemblyStorage storage = null;
        storage = this.getDisassemblyStorage() != null && this.getDisassemblyStorage().containsAddress(address) ? this.getDisassemblyStorage() : this.loadDisassemblyStorage(address);
        return storage;
    }

    private void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDisassemblyStorage(DisassemblyStorage ds) {
        this.fStorage = ds;
    }

    protected DisassemblyStorage getDisassemblyStorage() {
        return this.fStorage;
    }

    private DisassemblyStorage getSourceElement(IStackFrameInfo frameInfo) {
        long address;
        DisassemblyStorage storage = null;
        if (frameInfo != null && (address = frameInfo.getAddress()) != 0L) {
            storage = this.getDisassemblyStorage() != null && this.getDisassemblyStorage().containsAddress(address) ? this.getDisassemblyStorage() : this.loadDisassemblyStorage(frameInfo);
        }
        return storage;
    }

    private DisassemblyStorage loadDisassemblyStorage(IStackFrameInfo frameInfo) {
        ICDISourceManager sm;
        this.setDisassemblyStorage(null);
        if (frameInfo != null && this.getDebugTarget() != null && this.getDebugTarget().isSuspended() && (sm = this.getDebugTarget().getCDISession().getSourceManager()) != null) {
            long address;
            String fileName = frameInfo.getFile();
            int lineNumber = frameInfo.getFrameLineNumber();
            ICDIInstruction[] instructions = new ICDIInstruction[]{};
            if (fileName != null && fileName.length() > 0) {
                try {
                    instructions = sm.getInstructions(fileName, lineNumber, 100);
                }
                catch (CDIException cDIException) {}
            }
            if (instructions.length == 0 && (address = frameInfo.getAddress()) >= 0L) {
                try {
                    instructions = this.getFunctionInstructions(sm.getInstructions(address, address + 100L));
                }
                catch (CDIException e) {
                    CDebugCorePlugin.log(e);
                }
            }
            if (instructions.length > 0) {
                this.setDisassemblyStorage(new DisassemblyStorage(this.getDebugTarget(), instructions));
            }
        }
        return this.getDisassemblyStorage();
    }

    private DisassemblyStorage loadDisassemblyStorage(long address) {
        ICDISourceManager sm;
        this.setDisassemblyStorage(null);
        if (this.getDebugTarget() != null && this.getDebugTarget().isSuspended() && (sm = this.getDebugTarget().getCDISession().getSourceManager()) != null) {
            ICDIInstruction[] instructions = new ICDIInstruction[0];
            if (instructions.length == 0 && address >= 0L) {
                try {
                    instructions = this.getFunctionInstructions(sm.getInstructions(address, address + 100L));
                }
                catch (CDIException e) {
                    CDebugCorePlugin.log(e);
                }
            }
            if (instructions.length > 0) {
                this.setDisassemblyStorage(new DisassemblyStorage(this.getDebugTarget(), instructions));
            }
        }
        return this.getDisassemblyStorage();
    }

    private ICDIInstruction[] getFunctionInstructions(ICDIInstruction[] rawInstructions) {
        if (rawInstructions.length > 0 && rawInstructions[0].getFuntionName() != null && rawInstructions[0].getFuntionName().length() > 0) {
            ArrayList<ICDIInstruction> list = new ArrayList<ICDIInstruction>(rawInstructions.length);
            list.add(rawInstructions[0]);
            int i = 1;
            while (i < rawInstructions.length) {
                if (rawInstructions[0].getFuntionName().equals(rawInstructions[i].getFuntionName())) {
                    list.add(rawInstructions[i]);
                }
                ++i;
            }
            return list.toArray(new ICDIInstruction[list.size()]);
        }
        return rawInstructions;
    }
}

