/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.model.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.builder.model.ICBuildConfig;
import org.eclipse.cdt.core.builder.model.ICBuildConfigWorkingCopy;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfig;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class CBuildConfigWorkingCopy
extends CBuildConfig
implements ICBuildConfigWorkingCopy {
    private CBuildConfig fOriginal;
    private CBuildConfigInfo fInfo;
    private boolean fDirty = false;
    private String fName;
    private boolean fRenamed = false;
    private boolean fSuppressChange = true;
    private IContainer fContainer;

    protected CBuildConfigWorkingCopy(CBuildConfig original) throws CoreException {
        super(original.getLocation());
        this.setName(original.getName());
        this.copyFrom(original);
        this.setOriginal(original);
        this.fSuppressChange = false;
    }

    protected CBuildConfigWorkingCopy(CBuildConfig original, String name) throws CoreException {
        super(original.getLocation());
        this.copyFrom(original);
        this.setName(name);
        this.fSuppressChange = false;
    }

    protected CBuildConfigWorkingCopy(IContainer container, String name) {
        super((IPath)null);
        this.setName(name);
        this.setInfo(new CBuildConfigInfo());
        this.setContainer(container);
        this.fSuppressChange = false;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public ICBuildConfig doSave() throws CoreException {
        if (this.isDirty()) {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    CBuildConfigWorkingCopy.this.writeNewFile();
                    if (!CBuildConfigWorkingCopy.this.isNew() && CBuildConfigWorkingCopy.this.isMoved()) {
                        CBuildConfigWorkingCopy.this.getOriginal().delete();
                    }
                    CBuildConfigWorkingCopy.this.resetDirty();
                }
            };
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        return new CBuildConfig(this.getLocation());
    }

    protected void writeNewFile() throws CoreException {
        String xml = null;
        try {
            xml = this.getInfo().getAsXML();
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"CBuildConfigWorkingCopy.{0}_occurred_generating_launch_configuration_XML._1"), e.toString()), null));
        }
        if (this.isLocal()) {
            try {
                boolean added = false;
                File file = this.getLocation().toFile();
                File dir = this.getLocation().removeLastSegments(1).toFile();
                dir.mkdirs();
                if (!file.exists()) {
                    added = true;
                    file.createNewFile();
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(xml.getBytes("UTF8"));
                stream.close();
                if (added) {
                    this.getBuildConfigurationManager().configurationAdded(new CBuildConfig(this.getLocation()));
                }
                this.getBuildConfigurationManager().configurationChanged(new CBuildConfig(this.getLocation()));
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.getString((String)"CBuildConfigWorkingCopy.{0}_occurred_generating_launch_configuration_XML._1"), e.toString()), null));
            }
        } else {
            IFile file = this.getFile();
            IContainer dir = file.getParent();
            if (!dir.exists()) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.getString((String)"CBuildConfigWorkingCopy.Specified_container_for_launch_configuration_does_not_exist_2"), null));
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
            if (!file.exists()) {
                file.create((InputStream)stream, false, null);
            } else {
                file.setContents((InputStream)stream, false, false, null);
            }
        }
    }

    public void setAttribute(String attributeName, int value) {
        this.getInfo().setAttribute(attributeName, new Integer(value));
        this.setDirty();
    }

    public void setAttribute(String attributeName, String value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, boolean value) {
        this.getInfo().setAttribute(attributeName, new Boolean(value));
        this.setDirty();
    }

    public void setAttribute(String attributeName, List value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, Map value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public ICBuildConfig getOriginal() {
        return this.fOriginal;
    }

    private void copyFrom(CBuildConfig original) throws CoreException {
        CBuildConfigInfo info = original.getInfo();
        this.setInfo(info.getCopy());
        this.setContainer(original.getContainer());
        this.resetDirty();
    }

    private void setOriginal(CBuildConfig original) {
        this.fOriginal = original;
    }

    protected void setInfo(CBuildConfigInfo info) {
        this.fInfo = info;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    protected CBuildConfigInfo getInfo() {
        return this.fInfo;
    }

    private void setDirty() {
        this.fDirty = true;
        if (!this.suppressChangeNotification()) {
            this.getBuildConfigurationManager().configurationChanged(this);
        }
    }

    private void resetDirty() {
        this.fDirty = false;
    }

    public void rename(String name) {
        if (!this.getName().equals(name)) {
            this.setName(name);
            this.fRenamed = this.isNew() || !this.getOriginal().getName().equals(name);
        }
    }

    private void setName(String name) {
        this.fName = name;
        this.setDirty();
    }

    public String getName() {
        return this.fName;
    }

    public boolean isLocal() {
        return this.getContainer() == null;
    }

    public IPath getLocation() {
        if (this.isMoved()) {
            IPath path = this.getContainer().getLocation();
            path = path.append(String.valueOf(this.getName()) + "." + "build");
            return path;
        }
        return this.getOriginal().getLocation();
    }

    protected boolean isNew() {
        return this.getOriginal() == null;
    }

    protected boolean isMoved() {
        IContainer originalContainer;
        if (this.isNew() || this.fRenamed) {
            return true;
        }
        IContainer newContainer = this.getContainer();
        if (newContainer == (originalContainer = ((CBuildConfig)this.getOriginal()).getContainer())) {
            return false;
        }
        if (newContainer == null) {
            return !originalContainer.equals((Object)newContainer);
        }
        return !newContainer.equals((Object)originalContainer);
    }

    public String getMemento() {
        return null;
    }

    protected boolean suppressChangeNotification() {
        return this.fSuppressChange;
    }

    public void setContainer(IContainer container) {
        if (container == this.fContainer) {
            return;
        }
        if (container != null ? container.equals((Object)this.fContainer) : this.fContainer.equals((Object)container)) {
            return;
        }
        this.fContainer = container;
        this.setDirty();
    }

    protected IContainer getContainer() {
        return this.fContainer;
    }
}

