/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICOwner;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class COwner
implements ICOwnerInfo {
    String ownerID;
    String fPlatform;
    IExtension extension;

    public COwner(String id) throws CoreException {
        this.ownerID = id;
        IExtensionPoint extpoint = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("CProject");
        this.extension = extpoint.getExtension(this.ownerID);
        if (this.extension == null) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "Invalid CDTProject owner ID", null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getID() {
        return this.ownerID;
    }

    public String getName() {
        return this.extension == null ? null : this.extension.getLabel();
    }

    public String getPlatform() {
        if (this.fPlatform == null) {
            IConfigurationElement[] element = this.extension.getConfigurationElements();
            int i = 0;
            while (i < element.length) {
                if (element[i].getName().equalsIgnoreCase("cproject")) {
                    this.fPlatform = element[i].getAttribute("platform");
                    break;
                }
                ++i;
            }
        }
        return this.fPlatform == null ? "*" : this.fPlatform;
    }

    void configure(IProject project, ICDescriptor cproject) throws CoreException {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase("cproject")) {
                ICOwner owner = (ICOwner)element[i].createExecutableExtension("class");
                owner.configure(cproject);
                return;
            }
            ++i;
        }
        Status status = new Status(4, "org.eclipse.cdt.core", -1, "Invalid CDTProject owner extension", null);
        throw new CoreException((IStatus)status);
    }

    void update(IProject project, ICDescriptor cproject, String extensionID) throws CoreException {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase("cproject")) {
                ICOwner owner = (ICOwner)element[i].createExecutableExtension("class");
                owner.update(cproject, extensionID);
                return;
            }
            ++i;
        }
        Status status = new Status(4, "org.eclipse.cdt.core", -1, "Invalid CDTProject owner extension", null);
        throw new CoreException((IStatus)status);
    }
}

