/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.List;
import org.eclipse.cdt.core.build.managed.BuildException;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.IOptionCategory;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.BuildObject;
import org.eclipse.cdt.internal.core.build.managed.Tool;
import org.eclipse.core.runtime.IConfigurationElement;

public class Option
extends BuildObject
implements IOption {
    private ITool tool;
    private IOptionCategory category;
    private List enumValues;
    private int valueType;
    private Object value;
    private static final String[] emptyStrings = new String[0];

    public Option(ITool tool) {
        this.tool = tool;
    }

    public Option(Tool tool, IConfigurationElement element) {
        this(tool);
        this.setId(element.getAttribute("id"));
        tool.addOption(this);
        this.setName(element.getAttribute("name"));
        String categoryId = element.getAttribute("category");
        if (categoryId != null) {
            this.setCategory(tool.getOptionCategory(categoryId));
        }
    }

    public String[] getApplicableValues() {
        return this.enumValues != null ? this.enumValues.toArray(new String[this.enumValues.size()]) : emptyStrings;
    }

    public IOptionCategory getCategory() {
        return this.category != null ? this.category : this.getTool().getTopOptionCategory();
    }

    public String[] getStringListValue() {
        List v = (List)this.value;
        return v != null ? v.toArray(new String[v.size()]) : emptyStrings;
    }

    public String getStringValue() {
        return (String)this.value;
    }

    public ITool getTool() {
        return this.tool;
    }

    public int getValueType() {
        return this.valueType;
    }

    public IOption setValue(IConfiguration config, String value) throws BuildException {
        if (this.valueType != 0) {
            throw new BuildException("Bad value for type");
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }

    public IOption setValue(IConfiguration config, String[] value) throws BuildException {
        if (this.valueType != 1) {
            throw new BuildException("Bad value for type");
        }
        if (config == null) {
            this.value = value;
            return this;
        }
        return null;
    }

    public void setCategory(IOptionCategory category) {
        this.category = category;
    }
}

