/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.IOptionCategory;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.BuildObject;
import org.eclipse.cdt.internal.core.build.managed.Tool;
import org.eclipse.cdt.internal.core.build.managed.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;

public class OptionCategory
extends BuildObject
implements IOptionCategory {
    private IOptionCategory owner;
    private List children;
    private static final IOptionCategory[] emtpyCategories = new IOptionCategory[0];

    public OptionCategory(IOptionCategory owner) {
        this.owner = owner;
    }

    public OptionCategory(Tool tool, IConfigurationElement element) {
        String parentId = element.getAttribute("parent");
        this.owner = parentId != null ? tool.getOptionCategory(element.getAttribute("parent")) : tool;
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        if (this.owner instanceof Tool) {
            ((Tool)this.owner).addChildCategory(this);
        } else {
            ((OptionCategory)this.owner).addChildCategory(this);
        }
        tool.addOptionCategory(this);
    }

    public IOptionCategory[] getChildCategories() {
        if (this.children != null) {
            return this.children.toArray(new IOptionCategory[this.children.size()]);
        }
        return emtpyCategories;
    }

    public void addChildCategory(OptionCategory category) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(category);
    }

    public IOptionCategory getOwner() {
        return this.owner;
    }

    public ITool getTool() {
        return this.owner.getTool();
    }

    public IOption[] getOptions(IConfiguration configuration) {
        ITool tool = this.getTool();
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            int i = 0;
            while (i < tools.length) {
                if (tools[i] instanceof ToolReference) {
                    if (((ToolReference)tools[i]).references(tool)) {
                        tool = tools[i];
                        break;
                    }
                } else if (tools[i].equals(tool)) break;
                ++i;
            }
        }
        IOption[] allOptions = tool.getOptions();
        ArrayList<IOption> myOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this)) {
                myOptions.add(option);
            }
            ++i;
        }
        return myOptions.toArray(new IOption[myOptions.size()]);
    }
}

