/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.ITarget;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.core.build.managed.ManagedBuildManager;
import org.eclipse.cdt.internal.core.build.managed.BuildObject;
import org.eclipse.cdt.internal.core.build.managed.Configuration;
import org.eclipse.cdt.internal.core.build.managed.ResourceBuildInfo;
import org.eclipse.cdt.internal.core.build.managed.Tool;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private ITarget parent;
    private IResource owner;
    private List tools;
    private Map toolMap;
    private List configurations;
    private Map configMap;
    private boolean isAbstract = false;
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];

    public Target(IResource owner) {
        this.owner = owner;
    }

    public Target(IResource owner, ITarget parent) {
        this(owner);
        this.parent = parent;
        this.setId(parent.getId());
        this.setName(parent.getName());
        ResourceBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner, true);
        buildInfo.addTarget(this);
    }

    public Target(IConfigurationElement element) {
        this.setId(element.getAttribute("id"));
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(element.getAttribute("name"));
        String parentId = element.getAttribute("parent");
        if (parentId != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
            IConfiguration[] parentConfigs = this.parent.getConfigurations();
            int i = 0;
            while (i < parentConfigs.length) {
                this.addConfiguration(parentConfigs[i]);
                ++i;
            }
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        IConfigurationElement[] targetElements = element.getChildren();
        int k = 0;
        while (k < targetElements.length) {
            IConfigurationElement targetElement = targetElements[k];
            if (targetElement.getName().equals("tool")) {
                new Tool(this, targetElement);
            } else if (targetElement.getName().equals("configuration")) {
                new Configuration(this, targetElement);
            }
            ++k;
        }
    }

    public Target(ResourceBuildInfo buildInfo, Element element) {
        this(buildInfo.getOwner());
        this.setId(element.getAttribute("id"));
        buildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        String parentId = element.getAttribute("parent");
        if (parentId != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("configuration")) {
                new Configuration(this, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        if (this.configurations != null) {
            int i = 0;
            while (i < this.configurations.size()) {
                Configuration config = (Configuration)this.configurations.get(i);
                Element configElement = doc.createElement("configuration");
                element.appendChild(configElement);
                config.serealize(doc, configElement);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITarget getParent() {
        return this.parent;
    }

    public IResource getOwner() {
        return this.owner;
    }

    private int getNumTools() {
        int n;
        int n2 = n = this.tools == null ? 0 : this.tools.size();
        if (this.parent != null) {
            n += ((Target)this.parent).getNumTools();
        }
        return n;
    }

    private int addToolsToArray(ITool[] toolArray, int start) {
        int n = start;
        if (this.parent != null) {
            n = ((Target)this.parent).addToolsToArray(toolArray, start);
        }
        if (this.tools != null) {
            int i = 0;
            while (i < this.tools.size()) {
                toolArray[n++] = (ITool)this.tools.get(i);
                ++i;
            }
        }
        return n;
    }

    public ITool[] getTools() {
        ITool[] toolArray = new ITool[this.getNumTools()];
        this.addToolsToArray(toolArray, 0);
        return toolArray;
    }

    public ITool getTool(String id) {
        return (ITool)this.toolMap.get(id);
    }

    public void addTool(ITool tool) {
        if (this.tools == null) {
            this.tools = new ArrayList();
            this.toolMap = new HashMap();
        }
        this.tools.add(tool);
        this.toolMap.put(tool.getId(), tool);
    }

    public IConfiguration[] getConfigurations() {
        if (this.configurations != null) {
            return this.configurations.toArray(new IConfiguration[this.configurations.size()]);
        }
        return emptyConfigs;
    }

    public IConfiguration getConfiguration(String id) {
        return (IConfiguration)this.configMap.get(id);
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
            this.configMap = new HashMap();
        }
        this.configurations.add(configuration);
        this.configMap.put(configuration.getId(), configuration);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public IConfiguration createConfiguration(String id) {
        return new Configuration(this, id);
    }

    public IConfiguration createConfiguration(IConfiguration parent, String id) {
        return new Configuration(this, parent, id);
    }
}

