/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.List;
import org.eclipse.cdt.internal.core.dom.Name;
import org.eclipse.cdt.internal.core.parser.Token;

public class DeclSpecifier {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    private int declSpecifierSeq = 0;
    private boolean isTypename = false;
    public static final int t_type = 0;
    public static final int t_char = 1;
    public static final int t_wchar_t = 2;
    public static final int t_bool = 3;
    public static final int t_int = 4;
    public static final int t_float = 5;
    public static final int t_double = 6;
    public static final int t_void = 7;
    Name name = null;

    public int getDeclSpecifierSeq() {
        return this.declSpecifierSeq;
    }

    private void setBit(boolean b, int mask) {
        this.declSpecifierSeq = b ? (this.declSpecifierSeq |= mask) : (this.declSpecifierSeq &= ~mask);
    }

    private boolean checkBit(int mask) {
        int masked = this.declSpecifierSeq & mask;
        return masked != 0;
    }

    public void setAuto(boolean b) {
        this.setBit(b, 32);
    }

    public boolean isAuto() {
        return this.checkBit(32);
    }

    public void setRegister(boolean b) {
        this.setBit(b, 64);
    }

    public boolean isRegister() {
        return this.checkBit(64);
    }

    public void setStatic(boolean b) {
        this.setBit(b, 128);
    }

    public boolean isStatic() {
        return this.checkBit(128);
    }

    public void setExtern(boolean b) {
        this.setBit(b, 256);
    }

    public boolean isExtern() {
        return this.checkBit(256);
    }

    public void setMutable(boolean b) {
        this.setBit(b, 512);
    }

    public boolean isMutable() {
        return this.checkBit(512);
    }

    public void setInline(boolean b) {
        this.setBit(b, 1024);
    }

    public boolean isInline() {
        return this.checkBit(1024);
    }

    public void setVirtual(boolean b) {
        this.setBit(b, 2048);
    }

    public boolean isVirtual() {
        return this.checkBit(2048);
    }

    public void setExplicit(boolean b) {
        this.setBit(b, 4096);
    }

    public boolean isExplicit() {
        return this.checkBit(4096);
    }

    public void setTypedef(boolean b) {
        this.setBit(b, 8192);
    }

    public boolean isTypedef() {
        return this.checkBit(8192);
    }

    public void setFriend(boolean b) {
        this.setBit(b, 16384);
    }

    public boolean isFriend() {
        return this.checkBit(16384);
    }

    public void setConst(boolean b) {
        this.setBit(b, 32768);
    }

    public boolean isConst() {
        return this.checkBit(32768);
    }

    public void setVolatile(boolean b) {
        this.setBit(b, 65536);
    }

    public boolean isVolatile() {
        return this.checkBit(65536);
    }

    public void setUnsigned(boolean b) {
        this.setBit(b, 131072);
    }

    public boolean isUnsigned() {
        return this.checkBit(131072);
    }

    public void setShort(boolean b) {
        this.setBit(b, 262144);
    }

    public boolean isShort() {
        return this.checkBit(262144);
    }

    public void setLong(boolean b) {
        this.setBit(b, 524288);
    }

    public boolean isLong() {
        return this.checkBit(524288);
    }

    public void setType(Token token) {
        switch (token.getType()) {
            case 118: {
                this.setTypename(true);
                break;
            }
            case 57: {
                this.setAuto(true);
                break;
            }
            case 101: {
                this.setRegister(true);
                break;
            }
            case 106: {
                this.setStatic(true);
                break;
            }
            case 80: {
                this.setExtern(true);
                break;
            }
            case 90: {
                this.setMutable(true);
                break;
            }
            case 87: {
                this.setInline(true);
                break;
            }
            case 122: {
                this.setVirtual(true);
                break;
            }
            case 78: {
                this.setExplicit(true);
                break;
            }
            case 116: {
                this.setTypedef(true);
                break;
            }
            case 84: {
                this.setFriend(true);
                break;
            }
            case 67: {
                this.setConst(true);
                break;
            }
            case 124: {
                this.setVolatile(true);
                break;
            }
            case 64: {
                this.setType(1);
                break;
            }
            case 125: {
                this.setType(2);
                break;
            }
            case 60: {
                this.setType(3);
                break;
            }
            case 104: {
                this.setShort(true);
                break;
            }
            case 88: {
                this.setType(4);
                break;
            }
            case 89: {
                this.setLong(true);
                break;
            }
            case 108: {
                this.setUnsigned(false);
                break;
            }
            case 120: {
                this.setUnsigned(true);
                break;
            }
            case 82: {
                this.setType(5);
                break;
            }
            case 74: {
                this.setType(6);
                break;
            }
            case 123: {
                this.setType(7);
                break;
            }
            case 1: {
                this.setType(0);
            }
        }
    }

    public void setType(int t) {
        this.declSpecifierSeq = this.declSpecifierSeq & 0xFFFFFFE0 | t;
    }

    public int getType() {
        return this.declSpecifierSeq & 0x1F;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getTypeName() {
        StringBuffer type = new StringBuffer();
        switch (this.getType()) {
            case 1: {
                if (this.isUnsigned()) {
                    type.append("unsigned ");
                }
                type.append("char");
                break;
            }
            case 2: {
                if (this.isUnsigned()) {
                    type.append("unsigned ");
                }
                type.append("wchar_t");
                break;
            }
            case 3: {
                type.append("bool");
                break;
            }
            case 4: {
                if (this.isUnsigned()) {
                    type.append("unsigned ");
                }
                if (this.isShort()) {
                    type.append("short ");
                }
                if (this.isLong()) {
                    type.append("long ");
                }
                type.append("int");
                break;
            }
            case 5: {
                type.append("float");
                break;
            }
            case 6: {
                if (this.isLong()) {
                    type.append("long ");
                }
                type.append("double");
                break;
            }
            case 7: {
                type.append("void");
                break;
            }
            case 0: {
                if (this.isTypename()) {
                    type.append("typename ");
                }
                if (this.getName() != null) {
                    type.append(this.getName().toString());
                    break;
                }
                if (this.isUnsigned()) {
                    type.append("unsigned ");
                }
                if (this.isShort()) {
                    type.append("short ");
                }
                if (!this.isLong()) break;
                type.append("long ");
                break;
            }
            default: {
                return "";
            }
        }
        return type.toString();
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public void setTypename(boolean b) {
        this.isTypename = b;
    }

    public interface IContainer {
        public DeclSpecifier getDeclSpecifier();

        public void addDeclarator(Object var1);

        public List getDeclarators();
    }
}

