/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.core.dom.AccessSpecifier;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.IAccessable;
import org.eclipse.cdt.internal.core.dom.IScope;
import org.eclipse.cdt.internal.core.dom.ITemplateParameterListOwner;
import org.eclipse.cdt.internal.core.dom.TemplateParameterList;
import org.eclipse.cdt.internal.core.parser.Token;

public class TemplateDeclaration
extends Declaration
implements IScope,
IAccessable,
ITemplateParameterListOwner {
    private final boolean exported;
    private AccessSpecifier visibility = null;
    private Token firstToken;
    private Token lastToken;
    private List declarations = new ArrayList();
    private TemplateParameterList templateParms = null;

    public TemplateDeclaration(IScope ownerScope, Token exported) {
        super(ownerScope);
        this.firstToken = exported;
        this.exported = exported.getType() == 79;
    }

    public void addDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public List getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    public boolean isExported() {
        return this.exported;
    }

    public TemplateParameterList getTemplateParms() {
        return this.templateParms;
    }

    public void setTemplateParms(TemplateParameterList list) {
        this.templateParms = list;
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    public Token getLastToken() {
        return this.lastToken;
    }

    public void setFirstToken(Token token) {
        this.firstToken = token;
        this.setStartingOffset(this.getFirstToken().getOffset());
    }

    public void setLastToken(Token token) {
        this.lastToken = token;
        this.setTotalLength(this.getLastToken().getOffset() + this.getLastToken().getLength() - this.getStartingOffset());
    }

    public int getVisibility() {
        if (this.visibility == null) {
            return 3;
        }
        return this.visibility.getAccess();
    }

    public void setVisibility(int visibility) {
        if (this.visibility == null) {
            this.visibility = new AccessSpecifier(visibility);
        } else {
            this.visibility.setAccess(visibility);
        }
    }
}

