/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.internal.core.index.CTagsFileReader;
import org.eclipse.cdt.internal.core.index.CTagsHeader;

public class CTagsFileWriter {
    BufferedWriter writer = null;
    ITagEntry[] entries = null;

    public CTagsFileWriter(String tagfile) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(tagfile));
    }

    public CTagsFileWriter(Writer outfile) {
        this.writer = new BufferedWriter(outfile);
    }

    public void save(ITagEntry[] ent) throws IOException {
        this.setTagEntries(ent);
        this.save();
    }

    public void save() throws IOException {
        if (this.entries != null) {
            String header = CTagsHeader.header();
            this.writer.write(header, 0, header.length());
            int i = 0;
            while (i < this.entries.length) {
                String entry = this.entries[i].getLine();
                this.writer.write(entry, 0, entry.length());
                this.writer.newLine();
                ++i;
            }
            this.writer.flush();
            this.entries = null;
        }
    }

    public void setTagEntries(ITagEntry[] ent) {
        this.entries = ent;
    }

    public static void main(String[] args) {
        try {
            CTagsFileReader inFile = new CTagsFileReader(args[0]);
            ITagEntry[] entries = inFile.getTagEntries();
            CTagsFileWriter outFile = new CTagsFileWriter(String.valueOf(args[0]) + ".back");
            outFile.save(entries);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

