/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.internal.core.index.CTagsCmd;
import org.eclipse.cdt.internal.core.index.IndexManager;
import org.eclipse.cdt.internal.core.index.RequestList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CTagsRunner
implements Runnable {
    IndexManager manager;

    public CTagsRunner(IndexManager indexManager) {
        this.manager = indexManager;
    }

    public void run() {
        this.manager.delay();
        block8: while (true) {
            IResource resource = null;
            RequestList requestList = this.manager.getRequestList();
            try {
                resource = requestList.removeItem();
            }
            catch (Exception exception) {}
            if (resource == null) continue;
            switch (resource.getType()) {
                case 1: {
                    IProject project = resource.getProject();
                    Map projectsMap = this.manager.getProjectsMap();
                    Map<IPath, ITagEntry[]> filesMap = (Map<IPath, ITagEntry[]>)projectsMap.get(project.getLocation());
                    if (filesMap == null) {
                        filesMap = Collections.synchronizedMap(new HashMap());
                        projectsMap.put(project.getLocation(), filesMap);
                    }
                    try {
                        CTagsCmd cmd = new CTagsCmd();
                        IFile file = (IFile)resource;
                        IPath path = file.getLocation();
                        if (path == null) break;
                        ITagEntry[] entries = cmd.getTagEntries(file, path.toOSString());
                        filesMap.put(resource.getLocation(), entries);
                    }
                    catch (IOException iOException) {}
                    continue block8;
                }
                case 2: 
                case 4: {
                    System.out.println("Can not index folders " + resource.getName());
                }
            }
        }
    }
}

