/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class BinaryRunner
extends Thread {
    ArchiveContainer clib;
    BinaryContainer cbin;
    ICProject cproject;
    CModelManager factory;

    public BinaryRunner(ICProject cprj) {
        super("Binary Search Thread");
        this.cproject = cprj;
        this.cbin = (BinaryContainer)cprj.getBinaryContainer();
        this.clib = (ArchiveContainer)cprj.getArchiveContainer();
        this.factory = CModelManager.getDefault();
        this.start();
    }

    public void run() {
        this.clib.removeChildren();
        this.cbin.removeChildren();
        try {
            this.cproject.getProject().accept((IResourceVisitor)new Visitor(this));
        }
        catch (CoreException coreException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fireEvents(this.cbin);
        this.fireEvents(this.clib);
        BinaryRunner binaryRunner = this;
        synchronized (binaryRunner) {
            this.notifyAll();
        }
    }

    public synchronized void waitIfRunning() {
        while (this.isAlive()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void fireEvents(Parent container) {
        ICElement[] children = container.getChildren();
        if (children.length > 0) {
            CModelManager factory = CModelManager.getDefault();
            ICModel root = factory.getCModel();
            CElementDelta cdelta = new CElementDelta(root);
            cdelta.added(this.cproject);
            cdelta.added(container);
            int i = 0;
            while (i < children.length) {
                cdelta.added(children[i]);
                ++i;
            }
            factory.registerCModelDelta(cdelta);
            factory.fire();
        }
    }

    void addChildIfBinary(IFile file) {
        IBinaryParser.IBinaryFile bin;
        if (!this.factory.isTranslationUnit(file) && (bin = this.factory.createBinaryFile(file)) != null) {
            IContainer res = file.getParent();
            ICElement parent = this.factory.create((IResource)res);
            this.factory.create(parent, file, bin);
        }
    }

    class Visitor
    implements IResourceVisitor {
        BinaryRunner runner;

        public Visitor(BinaryRunner r) {
            this.runner = r;
        }

        public boolean visit(IResource res) throws CoreException {
            if (res instanceof IFile) {
                this.runner.addChildIfBinary((IFile)res);
                return false;
            }
            return true;
        }
    }
}

