/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.core.resources.IResource;

class CElementInfo {
    protected CElement element;
    protected ICElement[] fChildren;
    protected static ICElement[] fgEmptyChildren = new ICElement[0];
    protected boolean fIsStructureKnown = false;
    protected long modificationStamp = 0L;

    protected CElementInfo(CElement element) {
        this.element = element;
        this.fChildren = fgEmptyChildren;
    }

    protected CElement getElement() {
        return this.element;
    }

    protected void addChild(ICElement child) {
        if (this.fChildren == fgEmptyChildren) {
            this.setChildren(new ICElement[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.fChildren, child));
        }
    }

    protected ICElement[] getChildren() {
        return this.fChildren;
    }

    protected ICElement[] growAndAddToArray(ICElement[] array, ICElement addition) {
        ICElement[] old = array;
        array = new ICElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(ICElement child) {
        int i = 0;
        while (i < this.fChildren.length) {
            if (this.fChildren[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected ICElement[] removeAndShrinkArray(ICElement[] array, ICElement deletion) {
        ICElement[] old = array;
        array = new ICElement[old.length - 1];
        int j = 0;
        int i = 0;
        while (i < old.length) {
            if (old[i].equals(deletion)) {
                System.arraycopy(old, i + 1, array, j, old.length - (i + 1));
                return array;
            }
            array[j] = old[i];
            ++j;
            ++i;
        }
        return array;
    }

    protected void removeChild(ICElement child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.fChildren, child));
        }
    }

    protected void removeChildren() {
        this.fChildren = fgEmptyChildren;
    }

    protected void setChildren(ICElement[] children) {
        this.fChildren = children;
    }

    protected boolean hasChildren() {
        return this.fChildren.length > 0;
    }

    protected void setChanged() {
        this.modificationStamp = 0L;
    }

    protected boolean hasChanged() {
        IResource r = null;
        boolean b = false;
        try {
            r = this.getElement().getUnderlyingResource();
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        if (r != null && r.exists()) {
            long modif = 0L;
            switch (r.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    File file = r.getLocation().toFile();
                    modif = file.lastModified();
                    break;
                }
                case 1: {
                    modif = r.getModificationStamp();
                }
            }
            b = modif != this.modificationStamp;
            this.modificationStamp = modif;
        }
        return b;
    }

    protected void setIsStructureKnown(boolean newIsStructureKnown) {
        this.fIsStructureKnown = newIsStructureKnown;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

